/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.transport;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.kerby.kerberos.kerb.transport.KrbUdpTransport;

public class KdcUdpTransport
extends KrbUdpTransport {
    private BlockingQueue<ByteBuffer> bufferQueue = new ArrayBlockingQueue<ByteBuffer>(2);

    public KdcUdpTransport(DatagramChannel channel, InetSocketAddress remoteAddress) throws IOException {
        super(remoteAddress);
        this.setChannel(channel);
    }

    @Override
    public synchronized ByteBuffer receiveMessage() throws IOException {
        ByteBuffer message;
        long timeout = 1000L;
        try {
            message = this.bufferQueue.poll(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        return message;
    }

    protected synchronized void onRecvMessage(ByteBuffer message) {
        if (message != null) {
            this.bufferQueue.add(message);
        }
    }
}

