/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.security.token;

import java.security.Principal;
import java.util.Collections;
import java.util.List;
import javax.security.auth.Subject;
import org.apache.knox.gateway.services.security.token.JWTokenAttributes;

public class JWTokenAttributesBuilder {
    private Principal principal;
    private List<String> audiences;
    private String algorithm;
    private long expires;
    private String signingKeystoreName;
    private String signingKeystoreAlias;
    private char[] signingKeystorePassphrase;
    private boolean managed;
    private String jku;

    public JWTokenAttributesBuilder setPrincipal(Subject subject) {
        return this.setPrincipal((Principal)subject.getPrincipals().toArray()[0]);
    }

    public JWTokenAttributesBuilder setPrincipal(Principal principal) {
        this.principal = principal;
        return this;
    }

    public JWTokenAttributesBuilder setAudiences(String audience) {
        return this.setAudiences(Collections.singletonList(audience));
    }

    public JWTokenAttributesBuilder setAudiences(List<String> audiences) {
        this.audiences = audiences;
        return this;
    }

    public JWTokenAttributesBuilder setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public JWTokenAttributesBuilder setExpires(long expires) {
        this.expires = expires;
        return this;
    }

    public JWTokenAttributesBuilder setSigningKeystoreName(String signingKeystoreName) {
        this.signingKeystoreName = signingKeystoreName;
        return this;
    }

    public JWTokenAttributesBuilder setSigningKeystoreAlias(String signingKeystoreAlias) {
        this.signingKeystoreAlias = signingKeystoreAlias;
        return this;
    }

    public JWTokenAttributesBuilder setSigningKeystorePassphrase(char[] signingKeystorePassphrase) {
        this.signingKeystorePassphrase = signingKeystorePassphrase;
        return this;
    }

    public JWTokenAttributesBuilder setManaged(boolean managed) {
        this.managed = managed;
        return this;
    }

    public JWTokenAttributesBuilder setJku(String jku) {
        this.jku = jku;
        return this;
    }

    public JWTokenAttributes build() {
        return new JWTokenAttributes(this.principal, this.audiences == null ? Collections.emptyList() : this.audiences, this.algorithm, this.expires, this.signingKeystoreName, this.signingKeystoreAlias, this.signingKeystorePassphrase, this.managed, this.jku);
    }
}

