/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.client;

import java.util.ArrayList;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.saml.metadata.resolver.ChainingMetadataResolver;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.generator.ValueGenerator;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.context.SAML2ContextProvider;
import org.pac4j.saml.context.SAMLContextProvider;
import org.pac4j.saml.credentials.SAML2Credentials;
import org.pac4j.saml.credentials.authenticator.SAML2Authenticator;
import org.pac4j.saml.credentials.extractor.SAML2CredentialsExtractor;
import org.pac4j.saml.crypto.CredentialProvider;
import org.pac4j.saml.crypto.DefaultSignatureSigningParametersProvider;
import org.pac4j.saml.crypto.ExplicitSignatureTrustEngineProvider;
import org.pac4j.saml.crypto.KeyStoreCredentialProvider;
import org.pac4j.saml.crypto.KeyStoreDecryptionProvider;
import org.pac4j.saml.crypto.LogOnlySignatureTrustEngineProvider;
import org.pac4j.saml.crypto.SAML2SignatureTrustEngineProvider;
import org.pac4j.saml.crypto.SignatureSigningParametersProvider;
import org.pac4j.saml.logout.SAML2LogoutActionBuilder;
import org.pac4j.saml.logout.impl.SAML2LogoutMessageReceiver;
import org.pac4j.saml.logout.impl.SAML2LogoutProfileHandler;
import org.pac4j.saml.logout.impl.SAML2LogoutRequestMessageSender;
import org.pac4j.saml.logout.impl.SAML2LogoutValidator;
import org.pac4j.saml.metadata.SAML2IdentityProviderMetadataResolver;
import org.pac4j.saml.metadata.SAML2MetadataResolver;
import org.pac4j.saml.metadata.SAML2ServiceProviderMetadataResolver;
import org.pac4j.saml.profile.api.SAML2ProfileHandler;
import org.pac4j.saml.profile.api.SAML2ResponseValidator;
import org.pac4j.saml.profile.impl.AbstractSAML2MessageReceiver;
import org.pac4j.saml.redirect.SAML2RedirectionActionBuilder;
import org.pac4j.saml.replay.InMemoryReplayCacheProvider;
import org.pac4j.saml.replay.ReplayCacheProvider;
import org.pac4j.saml.sso.artifact.DefaultSOAPPipelineProvider;
import org.pac4j.saml.sso.artifact.SAML2ArtifactBindingMessageReceiver;
import org.pac4j.saml.sso.artifact.SOAPPipelineProvider;
import org.pac4j.saml.sso.impl.SAML2AuthnResponseValidator;
import org.pac4j.saml.sso.impl.SAML2WebSSOMessageReceiver;
import org.pac4j.saml.sso.impl.SAML2WebSSOMessageSender;
import org.pac4j.saml.sso.impl.SAML2WebSSOProfileHandler;
import org.pac4j.saml.state.SAML2StateGenerator;
import org.pac4j.saml.util.Configuration;

public class SAML2Client
extends IndirectClient<SAML2Credentials> {
    protected CredentialProvider credentialProvider;
    protected SAMLContextProvider contextProvider;
    protected SignatureSigningParametersProvider signatureSigningParametersProvider;
    protected SAML2ProfileHandler<AuthnRequest> profileHandler;
    protected SAML2ProfileHandler<LogoutRequest> logoutProfileHandler;
    protected SAML2ResponseValidator authnResponseValidator;
    protected SAML2ResponseValidator logoutValidator;
    protected SAML2SignatureTrustEngineProvider signatureTrustEngineProvider;
    protected SAML2MetadataResolver idpMetadataResolver;
    protected SAML2MetadataResolver spMetadataResolver;
    protected Decrypter decrypter;
    protected SAML2Configuration configuration;
    protected ValueGenerator stateGenerator = new SAML2StateGenerator(this);
    protected ReplayCacheProvider replayCache;
    protected SOAPPipelineProvider soapPipelineProvider;

    public SAML2Client() {
    }

    public SAML2Client(SAML2Configuration configuration) {
        this.configuration = configuration;
    }

    protected void clientInit() {
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)this.configuration));
        this.configuration.init(this.getName());
        this.initCredentialProvider();
        this.initDecrypter();
        this.initSignatureSigningParametersProvider();
        ChainingMetadataResolver metadataManager = this.initChainingMetadataResolver(this.initIdentityProviderMetadataResolver(), this.initServiceProviderMetadataResolver());
        this.initSAMLContextProvider((MetadataResolver)metadataManager);
        this.initSignatureTrustEngineProvider((MetadataResolver)metadataManager);
        this.initSAMLReplayCache();
        this.initSAMLResponseValidator();
        this.initSOAPPipelineProvider();
        this.initSAMLProfileHandler();
        this.initSAMLLogoutResponseValidator();
        this.initSAMLLogoutProfileHandler();
        this.defaultRedirectionActionBuilder(new SAML2RedirectionActionBuilder(this));
        this.defaultCredentialsExtractor(new SAML2CredentialsExtractor(this));
        this.defaultAuthenticator(new SAML2Authenticator(this.configuration.getAttributeAsId(), this.configuration.getMappedAttributes()));
        this.defaultLogoutActionBuilder(new SAML2LogoutActionBuilder(this));
    }

    protected void initSOAPPipelineProvider() {
        this.soapPipelineProvider = new DefaultSOAPPipelineProvider(this);
    }

    protected void initSAMLProfileHandler() {
        AbstractSAML2MessageReceiver messageReceiver;
        if (this.configuration.getResponseBindingType().equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST")) {
            messageReceiver = new SAML2WebSSOMessageReceiver(this.authnResponseValidator);
        } else if (this.configuration.getResponseBindingType().equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact")) {
            messageReceiver = new SAML2ArtifactBindingMessageReceiver(this.authnResponseValidator, this.idpMetadataResolver, this.spMetadataResolver, this.soapPipelineProvider);
        } else {
            throw new TechnicalException("Unsupported response binding type: " + this.configuration.getResponseBindingType());
        }
        this.profileHandler = new SAML2WebSSOProfileHandler(new SAML2WebSSOMessageSender(this.signatureSigningParametersProvider, this.configuration.getAuthnRequestBindingType(), true, this.configuration.isAuthnRequestSigned()), messageReceiver);
    }

    protected void initSAMLLogoutProfileHandler() {
        this.logoutProfileHandler = new SAML2LogoutProfileHandler(new SAML2LogoutRequestMessageSender(this.signatureSigningParametersProvider, this.configuration.getSpLogoutRequestBindingType(), false, this.configuration.isSpLogoutRequestSigned()), new SAML2LogoutMessageReceiver(this.logoutValidator));
    }

    protected void initSAMLLogoutResponseValidator() {
        this.logoutValidator = new SAML2LogoutValidator(this.signatureTrustEngineProvider, this.decrypter, this.configuration.getLogoutHandler(), this.configuration.getPostLogoutURL(), this.replayCache);
        this.logoutValidator.setAcceptedSkew(this.configuration.getAcceptedSkew());
    }

    protected void initSAMLResponseValidator() {
        this.authnResponseValidator = new SAML2AuthnResponseValidator(this.signatureTrustEngineProvider, this.decrypter, this.configuration.getLogoutHandler(), this.configuration.getMaximumAuthenticationLifetime(), this.configuration.isWantsAssertionsSigned(), this.configuration.isWantsResponsesSigned(), this.replayCache, this.configuration.isAllSignatureValidationDisabled());
        this.authnResponseValidator.setAcceptedSkew(this.configuration.getAcceptedSkew());
    }

    protected void initSignatureTrustEngineProvider(MetadataResolver metadataManager) {
        this.signatureTrustEngineProvider = new ExplicitSignatureTrustEngineProvider(metadataManager);
        if (this.configuration.isAllSignatureValidationDisabled()) {
            this.signatureTrustEngineProvider = new LogOnlySignatureTrustEngineProvider(this.signatureTrustEngineProvider);
        }
    }

    protected void initSAMLContextProvider(MetadataResolver metadataManager) {
        this.contextProvider = new SAML2ContextProvider(metadataManager, this.idpMetadataResolver, this.spMetadataResolver, this.configuration.getSamlMessageStoreFactory());
    }

    protected MetadataResolver initServiceProviderMetadataResolver() {
        this.spMetadataResolver = new SAML2ServiceProviderMetadataResolver(this.configuration, this.computeFinalCallbackUrl(null), this.credentialProvider);
        return this.spMetadataResolver.resolve();
    }

    protected MetadataResolver initIdentityProviderMetadataResolver() {
        this.idpMetadataResolver = new SAML2IdentityProviderMetadataResolver(this.configuration);
        return this.idpMetadataResolver.resolve();
    }

    protected void initCredentialProvider() {
        this.credentialProvider = new KeyStoreCredentialProvider(this.configuration);
    }

    protected void initDecrypter() {
        this.decrypter = new KeyStoreDecryptionProvider(this.credentialProvider).build();
    }

    protected void initSignatureSigningParametersProvider() {
        this.signatureSigningParametersProvider = new DefaultSignatureSigningParametersProvider(this.credentialProvider, this.configuration);
    }

    protected ChainingMetadataResolver initChainingMetadataResolver(MetadataResolver idpMetadataProvider, MetadataResolver spMetadataProvider) {
        ChainingMetadataResolver metadataManager = new ChainingMetadataResolver();
        metadataManager.setId(ChainingMetadataResolver.class.getCanonicalName());
        try {
            ArrayList<MetadataResolver> list = new ArrayList<MetadataResolver>();
            list.add(idpMetadataProvider);
            list.add(spMetadataProvider);
            metadataManager.setResolvers(list);
            metadataManager.initialize();
        }
        catch (ResolverException e) {
            throw new TechnicalException("Error adding idp or sp metadatas to manager", (Throwable)e);
        }
        catch (ComponentInitializationException e) {
            throw new TechnicalException("Error initializing manager", (Throwable)e);
        }
        return metadataManager;
    }

    protected void initSAMLReplayCache() {
        this.replayCache = new InMemoryReplayCacheProvider();
    }

    public void destroy() {
        ((SAML2ServiceProviderMetadataResolver)this.spMetadataResolver).destroy();
    }

    public void notifySessionRenewal(String oldSessionId, WebContext context) {
        this.configuration.findLogoutHandler().renewSession(oldSessionId, context);
    }

    public SAML2ResponseValidator getAuthnResponseValidator() {
        return this.authnResponseValidator;
    }

    public final SAML2MetadataResolver getServiceProviderMetadataResolver() {
        return this.spMetadataResolver;
    }

    public final SAML2MetadataResolver getIdentityProviderMetadataResolver() {
        return this.idpMetadataResolver;
    }

    public final String getIdentityProviderResolvedEntityId() {
        return this.idpMetadataResolver.getEntityId();
    }

    public final String getServiceProviderResolvedEntityId() {
        return this.spMetadataResolver.getEntityId();
    }

    public void setConfiguration(SAML2Configuration configuration) {
        this.configuration = configuration;
    }

    public final SAML2Configuration getConfiguration() {
        return this.configuration;
    }

    public SAMLContextProvider getContextProvider() {
        return this.contextProvider;
    }

    public SAML2ProfileHandler<AuthnRequest> getProfileHandler() {
        return this.profileHandler;
    }

    public SignatureSigningParametersProvider getSignatureSigningParametersProvider() {
        return this.signatureSigningParametersProvider;
    }

    public SAML2SignatureTrustEngineProvider getSignatureTrustEngineProvider() {
        return this.signatureTrustEngineProvider;
    }

    public ValueGenerator getStateGenerator() {
        return this.stateGenerator;
    }

    public void setStateGenerator(ValueGenerator stateGenerator) {
        CommonHelper.assertNotNull((String)"stateGenerator", (Object)stateGenerator);
        this.stateGenerator = stateGenerator;
    }

    public SAML2ProfileHandler<LogoutRequest> getLogoutProfileHandler() {
        return this.logoutProfileHandler;
    }

    public void setLogoutProfileHandler(SAML2ProfileHandler<LogoutRequest> logoutProfileHandler) {
        this.logoutProfileHandler = logoutProfileHandler;
    }

    public ReplayCacheProvider getReplayCache() {
        return this.replayCache;
    }

    static {
        CommonHelper.assertNotNull((String)"parserPool", (Object)Configuration.getParserPool());
        CommonHelper.assertNotNull((String)"marshallerFactory", (Object)Configuration.getMarshallerFactory());
        CommonHelper.assertNotNull((String)"unmarshallerFactory", (Object)Configuration.getUnmarshallerFactory());
        CommonHelper.assertNotNull((String)"builderFactory", (Object)Configuration.getBuilderFactory());
    }
}

