/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.filter;

import java.io.IOException;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.knox.gateway.audit.api.CorrelationContext;
import org.apache.knox.gateway.audit.api.CorrelationService;
import org.apache.knox.gateway.audit.api.CorrelationServiceFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;

public class CorrelationHandler
extends HandlerWrapper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        CorrelationService correlationService = CorrelationServiceFactory.getCorrelationService();
        CorrelationContext correlationContext = correlationService.createContext();
        correlationContext.setRequestId(UUID.randomUUID().toString());
        try {
            super.handle(target, baseRequest, request, response);
        }
        finally {
            correlationContext.destroy();
            correlationService.detachContext();
        }
    }
}

