/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.simple;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.Service;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.KeystoreService;
import org.apache.knox.gateway.services.security.MasterService;
import org.apache.knox.gateway.services.topology.TopologyService;
import org.apache.knox.gateway.topology.Topology;
import org.apache.knox.gateway.topology.discovery.DefaultServiceDiscoveryConfig;
import org.apache.knox.gateway.topology.discovery.ServiceDiscovery;
import org.apache.knox.gateway.topology.discovery.ServiceDiscoveryConfig;
import org.apache.knox.gateway.topology.discovery.ServiceDiscoveryFactory;
import org.apache.knox.gateway.topology.simple.ProviderConfiguration;
import org.apache.knox.gateway.topology.simple.ProviderConfigurationParser;
import org.apache.knox.gateway.topology.simple.SimpleDescriptor;
import org.apache.knox.gateway.topology.simple.SimpleDescriptorFactory;
import org.apache.knox.gateway.topology.simple.SimpleDescriptorMessages;

public class SimpleDescriptorHandler {
    public static final String RESULT_TOPOLOGY = "topology";
    public static final String RESULT_REFERENCE = "reference";
    private static final String DEFAULT_DISCOVERY_TYPE = "AMBARI";
    private static final String[] PROVIDER_CONFIG_FILE_EXTENSIONS = new String[ProviderConfigurationParser.SUPPORTED_EXTENSIONS.size()];
    private static final Service[] NO_GATEWAY_SERVICES;
    private static final SimpleDescriptorMessages log;
    private static final String DISCOVERY_PARAM_PREFIX = "discovery-";
    private static Map<String, ServiceDiscovery> discoveryInstances;
    private static final Set<String> ALLOWED_SERVICES_WITHOUT_URLS_AND_PARAMS;

    public static Map<String, File> handle(GatewayConfig config, File desc, File destDirectory, Service ... gatewayServices) throws IOException {
        return SimpleDescriptorHandler.handle(config, SimpleDescriptorFactory.parse(desc.getAbsolutePath()), desc.getParentFile(), destDirectory, gatewayServices);
    }

    public static Map<String, File> handle(GatewayConfig config, SimpleDescriptor desc, File srcDirectory, File destDirectory) {
        return SimpleDescriptorHandler.handle(config, desc, srcDirectory, destDirectory, NO_GATEWAY_SERVICES);
    }

    public static Map<String, File> handle(GatewayConfig config, SimpleDescriptor desc, File srcDirectory, File destDirectory, Service ... gatewayServices) {
        ArrayList<String> declaredServiceNames = new ArrayList<String>();
        TreeSet<String> validServiceNames = new TreeSet<String>();
        HashMap<String, String> serviceVersions = new HashMap<String, String>();
        HashMap<String, Map<String, String>> serviceParams = new HashMap<String, Map<String, String>>();
        HashMap<String, List<String>> serviceURLs = new HashMap<String, List<String>>();
        ServiceDiscovery.Cluster cluster = null;
        if (SimpleDescriptorHandler.shouldPerformDiscovery(desc)) {
            cluster = SimpleDescriptorHandler.performDiscovery(config, desc, gatewayServices);
            if (cluster == null) {
                log.failedToDiscoverClusterServices(desc.getName());
            }
        } else {
            log.discoveryNotConfiguredForDescriptor(desc.getName());
        }
        for (SimpleDescriptor.Service descService : desc.getServices()) {
            List descServiceURLs;
            String serviceName = descService.getName();
            declaredServiceNames.add(serviceName);
            String serviceVer = descService.getVersion();
            if (serviceVer != null) {
                serviceVersions.put(serviceName, serviceVer);
            }
            if (((descServiceURLs = descService.getURLs()) == null || descServiceURLs.isEmpty()) && cluster != null) {
                descServiceURLs = cluster.getServiceURLs(serviceName, descService.getParams());
            }
            ArrayList<String> validURLs = new ArrayList<String>();
            if (descServiceURLs != null && !descServiceURLs.isEmpty()) {
                for (String descServiceURL : descServiceURLs) {
                    if (!SimpleDescriptorHandler.validateURL(serviceName, descServiceURL)) continue;
                    validURLs.add(descServiceURL);
                }
                if (!validURLs.isEmpty()) {
                    validServiceNames.add(serviceName);
                }
            }
            if (!validURLs.isEmpty()) {
                serviceURLs.put(serviceName, validURLs);
            } else {
                log.failedToDiscoverClusterServiceURLs(serviceName, cluster != null ? cluster.getName() : "");
            }
            Map<String, String> descriptorServiceParams = descService.getParams();
            if (descriptorServiceParams != null && !descriptorServiceParams.isEmpty()) {
                boolean hasNonDiscoveryParams = false;
                for (String paramName : descriptorServiceParams.keySet()) {
                    if (paramName.startsWith(DISCOVERY_PARAM_PREFIX)) continue;
                    hasNonDiscoveryParams = true;
                    break;
                }
                if (hasNonDiscoveryParams) {
                    serviceParams.put(serviceName, descService.getParams());
                    validServiceNames.add(serviceName);
                }
            }
            if (!ALLOWED_SERVICES_WITHOUT_URLS_AND_PARAMS.contains(serviceName)) continue;
            validServiceNames.add(serviceName);
        }
        GatewayServices gws = SimpleDescriptorHandler.getGatewayServices(gatewayServices);
        if (!SimpleDescriptorHandler.provisionQueryParamEncryptionCredential(desc.getName(), gws)) {
            log.unableCreatePasswordForEncryption(desc.getName());
        }
        return SimpleDescriptorHandler.generateTopology(desc, srcDirectory, destDirectory, cluster, declaredServiceNames, validServiceNames, serviceVersions, serviceURLs, serviceParams, gws);
    }

    private static boolean shouldPerformDiscovery(SimpleDescriptor desc) {
        String discoveryType = desc.getDiscoveryType();
        if (discoveryType != null && !discoveryType.isEmpty()) {
            return true;
        }
        log.missingDiscoveryTypeInDescriptor(desc.getName());
        return false;
    }

    private static GatewayServices getGatewayServices(Service ... services) {
        for (Service service : services) {
            if (!(service instanceof GatewayServices)) continue;
            return (GatewayServices)service;
        }
        return null;
    }

    private static ServiceDiscovery.Cluster performDiscovery(GatewayConfig config, SimpleDescriptor desc, Service ... gatewayServices) {
        ServiceDiscovery sd;
        DefaultServiceDiscoveryConfig sdc = new DefaultServiceDiscoveryConfig(desc.getDiscoveryAddress());
        sdc.setCluster(desc.getCluster());
        sdc.setUser(desc.getDiscoveryUser());
        sdc.setPasswordAlias(desc.getDiscoveryPasswordAlias());
        String discoveryType = desc.getDiscoveryType();
        if (discoveryType == null) {
            discoveryType = DEFAULT_DISCOVERY_TYPE;
        }
        if ((sd = discoveryInstances.get(discoveryType)) == null) {
            sd = ServiceDiscoveryFactory.get((String)discoveryType, (Service[])gatewayServices);
            if (sd == null) {
                throw new IllegalArgumentException("Unsupported service discovery type: " + discoveryType);
            }
            discoveryInstances.put(discoveryType, sd);
        }
        return sd.discover(config, (ServiceDiscoveryConfig)sdc, desc.getCluster());
    }

    private static ProviderConfiguration handleProviderConfiguration(SimpleDescriptor desc, File providerConfig) {
        if (providerConfig == null || !providerConfig.exists()) {
            log.failedToResolveProviderConfigRef(desc.getProviderConfig());
            throw new IllegalArgumentException("Unresolved provider configuration reference: " + desc.getProviderConfig());
        }
        ProviderConfiguration parsedConfig = null;
        try {
            parsedConfig = ProviderConfigurationParser.parse(providerConfig);
        }
        catch (Exception e) {
            log.failedToParseProviderConfig(providerConfig.getAbsolutePath(), e);
        }
        return parsedConfig;
    }

    private static boolean provisionQueryParamEncryptionCredential(String topologyName, GatewayServices services) {
        boolean result = false;
        try {
            KeystoreService ks;
            MasterService ms;
            if (services != null && (ms = (MasterService)services.getService(ServiceType.MASTER_SERVICE)) != null && (ks = (KeystoreService)services.getService(ServiceType.KEYSTORE_SERVICE)) != null) {
                AliasService aliasService;
                if (!ks.isCredentialStoreForClusterAvailable(topologyName)) {
                    ks.createCredentialStoreForCluster(topologyName);
                }
                if (ks.getCredentialStoreForCluster(topologyName) != null && (aliasService = (AliasService)services.getService(ServiceType.ALIAS_SERVICE)) != null) {
                    String queryEncryptionPass = new String(ms.getMasterSecret()) + topologyName;
                    aliasService.addAliasForCluster(topologyName, "encryptQueryString", queryEncryptionPass);
                    result = true;
                }
            }
        }
        catch (Exception e) {
            log.exceptionCreatingPasswordForEncryption(topologyName, e);
        }
        return result;
    }

    private static boolean validateURL(String serviceName, String url) {
        boolean result = false;
        if (url != null && !url.isEmpty()) {
            try {
                new URI(url);
                result = true;
            }
            catch (URISyntaxException e) {
                log.serviceURLValidationFailed(serviceName, url, e);
            }
        }
        return result;
    }

    private static File resolveProviderConfigurationReference(String reference, File srcDirectory) {
        File providerConfig;
        if (reference.contains(File.separator)) {
            providerConfig = new File(reference);
            if (!providerConfig.exists() && !(providerConfig = new File(srcDirectory, reference)).exists()) {
                providerConfig = null;
            }
        } else {
            File sharedProvidersDir;
            providerConfig = new File(srcDirectory, reference);
            if (!providerConfig.exists() && (sharedProvidersDir = new File(srcDirectory, "../shared-providers")).exists() && !(providerConfig = new File(sharedProvidersDir, reference)).exists()) {
                for (String ext : PROVIDER_CONFIG_FILE_EXTENSIONS) {
                    providerConfig = new File(sharedProvidersDir, reference + ext);
                    if (providerConfig.exists()) break;
                    providerConfig = null;
                }
            }
        }
        return providerConfig;
    }

    /*
     * WARNING - void declaration
     */
    private static Map<String, File> generateTopology(SimpleDescriptor desc, File srcDirectory, File destDirectory, ServiceDiscovery.Cluster cluster, List<String> declaredServiceNames, Set<String> validServiceNames, Map<String, String> serviceVersions, Map<String, List<String>> serviceURLs, Map<String, Map<String, String>> serviceParams, GatewayServices gwServices) {
        File topologyDescriptor;
        HashMap<String, File> result;
        block80: {
            result = new HashMap<String, File>();
            topologyDescriptor = null;
            try (StringWriter sw = new StringWriter();){
                void var21_40;
                Object haProviderParams;
                File providerConfigFile = null;
                ProviderConfiguration providerConfiguration = null;
                String providerConfigReference = desc.getProviderConfig();
                if (providerConfigReference != null) {
                    providerConfigFile = SimpleDescriptorHandler.resolveProviderConfigurationReference(providerConfigReference, srcDirectory);
                    providerConfiguration = SimpleDescriptorHandler.handleProviderConfiguration(desc, providerConfigFile);
                }
                if (providerConfiguration == null) {
                    throw new IllegalArgumentException("Invalid provider configuration: " + providerConfigReference);
                }
                result.put(RESULT_REFERENCE, providerConfigFile);
                ProviderConfiguration.Provider haProvider = null;
                for (ProviderConfiguration.Provider provider : providerConfiguration.getProviders()) {
                    if (!"ha".equals(provider.getRole())) continue;
                    haProvider = provider;
                    break;
                }
                HashMap<String, ServiceDiscovery.Cluster.ZooKeeperConfig> haServiceParams = new HashMap<String, ServiceDiscovery.Cluster.ZooKeeperConfig>();
                if (cluster != null && haProvider != null && (haProviderParams = haProvider.getParams()) != null) {
                    Set<String> set = haProviderParams.keySet();
                    for (String string : set) {
                        ServiceDiscovery.Cluster.ZooKeeperConfig zkConfig = cluster.getZooKeeperConfiguration(string);
                        if (zkConfig == null) continue;
                        haServiceParams.put(string, zkConfig);
                    }
                }
                sw.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
                sw.write("<!--==============================================-->\n");
                sw.write("<!-- DO NOT EDIT. This is an auto-generated file. -->\n");
                sw.write("<!--==============================================-->\n");
                sw.write("<topology>\n");
                sw.write("    <generated>true</generated>\n");
                sw.write("    <gateway>\n");
                for (ProviderConfiguration.Provider provider : providerConfiguration.getProviders()) {
                    sw.write("        <provider>\n");
                    sw.write("            <role>" + provider.getRole() + "</role>\n");
                    sw.write("            <name>" + provider.getName() + "</name>\n");
                    sw.write("            <enabled>" + provider.isEnabled() + "</enabled>\n");
                    for (Map.Entry<String, String> entry : provider.getParams().entrySet()) {
                        sw.write("            <param>\n");
                        sw.write("                <name>" + entry.getKey() + "</name>\n");
                        sw.write("                <value>" + entry.getValue() + "</value>\n");
                        sw.write("            </param>\n");
                    }
                    sw.write("        </provider>\n");
                }
                sw.write("    </gateway>\n");
                TreeSet<String> serviceNames = new TreeSet<String>(validServiceNames);
                for (String string : haServiceParams.keySet()) {
                    if (!declaredServiceNames.contains(string) || serviceNames.contains(string)) continue;
                    serviceNames.add(string);
                }
                for (String string : serviceNames) {
                    String serviceHaParams;
                    Map<String, String> map;
                    String enabledValue;
                    Map<String, String> haParams;
                    sw.write("\n");
                    sw.write("    <service>\n");
                    sw.write("        <role>" + string + "</role>\n");
                    if (serviceVersions.containsKey(string)) {
                        sw.write("        <version>" + serviceVersions.get(string) + "</version>\n");
                    }
                    Map map2 = serviceParams.computeIfAbsent(string, k -> new HashMap());
                    ServiceDiscovery.Cluster.ZooKeeperConfig zkConf = (ServiceDiscovery.Cluster.ZooKeeperConfig)haServiceParams.get(string);
                    boolean isServiceHaEnabledAuto = false;
                    boolean isServiceHaEnabled = false;
                    if (haProvider != null && (haParams = haProvider.getParams()) != null && haParams.containsKey(string) && (enabledValue = (map = SimpleDescriptorHandler.parseHaProviderParam(serviceHaParams = haParams.get(string))).get("enabled")) != null) {
                        if ("auto".equalsIgnoreCase(enabledValue)) {
                            isServiceHaEnabledAuto = true;
                            isServiceHaEnabled = zkConf != null && zkConf.isEnabled();
                        } else {
                            isServiceHaEnabled = "true".equalsIgnoreCase(enabledValue);
                        }
                    }
                    if (isServiceHaEnabledAuto) {
                        map2.put("haEnabled", String.valueOf(isServiceHaEnabled));
                    }
                    if (zkConf != null && zkConf.getEnsemble() != null && isServiceHaEnabled) {
                        String namespace;
                        String ensemble = zkConf.getEnsemble();
                        if (ensemble != null && !ensemble.isEmpty()) {
                            map2.put("zookeeperEnsemble", ensemble);
                        }
                        if ((namespace = zkConf.getNamespace()) != null && !namespace.isEmpty()) {
                            map2.put("zookeeperNamespace", namespace);
                        }
                    } else {
                        List<String> urls = serviceURLs.get(string);
                        if (urls != null) {
                            for (String string2 : urls) {
                                sw.write("        <url>" + string2 + "</url>\n");
                            }
                        }
                    }
                    Map<String, String> svcParams = serviceParams.get(string);
                    if (svcParams != null) {
                        for (Map.Entry entry : svcParams.entrySet()) {
                            if (((String)entry.getKey()).toLowerCase(Locale.ROOT).startsWith(DISCOVERY_PARAM_PREFIX)) continue;
                            sw.write("        <param>\n");
                            sw.write("            <name>" + (String)entry.getKey() + "</name>\n");
                            sw.write("            <value>" + (String)entry.getValue() + "</value>\n");
                            sw.write("        </param>\n");
                        }
                    }
                    sw.write("    </service>\n");
                }
                List<SimpleDescriptor.Application> list = desc.getApplications();
                if (list != null) {
                    for (SimpleDescriptor.Application application : list) {
                        Map<String, String> appParams;
                        sw.write("    <application>\n");
                        sw.write("        <name>" + application.getName() + "</name>\n");
                        List<String> urls = application.getURLs();
                        if (urls != null) {
                            for (String url : urls) {
                                sw.write("        <url>" + url + "</url>\n");
                            }
                        }
                        if ((appParams = application.getParams()) != null) {
                            for (Map.Entry<String, String> entry : appParams.entrySet()) {
                                sw.write("        <param>\n");
                                sw.write("            <name>" + entry.getKey() + "</name>\n");
                                sw.write("            <value>" + entry.getValue() + "</value>\n");
                                sw.write("        </param>\n");
                            }
                        }
                        sw.write("    </application>\n");
                    }
                }
                sw.write("</topology>\n");
                String string = desc.getName();
                if (string == null) {
                    String string3 = desc.getCluster();
                }
                if (SimpleDescriptorHandler.shouldPersistGeneratedTopology((String)var21_40, topologyDescriptor = new File(destDirectory, (String)var21_40 + ".xml"), sw.toString(), gwServices)) {
                    log.persistingGeneratedTopology((String)var21_40);
                    try (OutputStream outputStream = Files.newOutputStream(topologyDescriptor.toPath(), new OpenOption[0]);
                         OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);){
                        BufferedWriter fw = new BufferedWriter(outputStreamWriter);
                        Object object = null;
                        try {
                            fw.write(sw.toString());
                            fw.flush();
                            break block80;
                        }
                        catch (Throwable throwable) {
                            object = throwable;
                            throw throwable;
                        }
                        finally {
                            if (fw != null) {
                                if (object != null) {
                                    try {
                                        fw.close();
                                    }
                                    catch (Throwable throwable) {
                                        ((Throwable)object).addSuppressed(throwable);
                                    }
                                } else {
                                    fw.close();
                                }
                            }
                        }
                    }
                }
                log.skippingDeploymentOfGeneratedTopology((String)var21_40);
            }
            catch (IOException e) {
                log.failedToGenerateTopologyFromSimpleDescriptor(topologyDescriptor.getName(), e);
                topologyDescriptor.delete();
            }
        }
        result.put(RESULT_TOPOLOGY, topologyDescriptor);
        return result;
    }

    private static boolean shouldPersistGeneratedTopology(String topologyName, File topologyFile, String generatedContent, GatewayServices gwServices) {
        boolean result = false;
        if (topologyFile.exists()) {
            Topology existing = null;
            TopologyService topologyService = null;
            if (gwServices != null) {
                topologyService = (TopologyService)gwServices.getService(ServiceType.TOPOLOGY_SERVICE);
                for (Topology t : topologyService.getTopologies()) {
                    if (!topologyName.equals(t.getName())) continue;
                    existing = t;
                    break;
                }
            }
            if (existing != null) {
                try (ByteArrayInputStream in = new ByteArrayInputStream(generatedContent.getBytes(StandardCharsets.UTF_8));){
                    Topology generatedTopology = topologyService.parse((InputStream)in);
                    generatedTopology.setName(topologyName);
                    result = !existing.equals((Object)generatedTopology);
                }
                catch (Exception e) {
                    log.errorComparingGeneratedTopology(topologyName, e);
                }
            } else {
                result = true;
            }
        } else {
            result = true;
        }
        return result;
    }

    private static Map<String, String> parseHaProviderParam(String paramValue) {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] elements = paramValue.split(";");
        if (elements.length > 0) {
            for (String element : elements) {
                String[] kv = element.split("=");
                if (kv.length != 2) continue;
                result.put(kv[0], kv[1]);
            }
        }
        return result;
    }

    static {
        int i = 0;
        for (String ext : ProviderConfigurationParser.SUPPORTED_EXTENSIONS) {
            SimpleDescriptorHandler.PROVIDER_CONFIG_FILE_EXTENSIONS[i++] = "." + ext;
        }
        NO_GATEWAY_SERVICES = new Service[0];
        log = (SimpleDescriptorMessages)MessagesFactory.get(SimpleDescriptorMessages.class);
        discoveryInstances = new HashMap<String, ServiceDiscovery>();
        ALLOWED_SERVICES_WITHOUT_URLS_AND_PARAMS = Collections.unmodifiableSet(Stream.of("KNOX", "KNOX-METADATA", "KNOXSSOUT", "KNOX-SESSION").collect(Collectors.toSet()));
    }
}

