/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.tapmessage;

import java.nio.ByteBuffer;
import net.spy.memcached.compat.SpyObject;
import net.spy.memcached.tapmessage.TapMagic;
import net.spy.memcached.tapmessage.TapOpcode;

public abstract class BaseMessage
extends SpyObject {
    private static final int MAGIC_OFFSET = 0;
    private static final int OPCODE_OFFSET = 1;
    private static final int KEYLENGTH_OFFSET = 2;
    private static final int EXTRALENGTH_OFFSET = 4;
    private static final int DATATYPE_OFFSET = 5;
    private static final int VBUCKET_OFFSET = 6;
    private static final int TOTALBODY_OFFSET = 8;
    private static final int OPAQUE_OFFSET = 12;
    private static final int CAS_OFFSET = 16;
    public static final int HEADER_LENGTH = 24;
    protected TapMagic magic;
    protected TapOpcode opcode;
    protected short keylength;
    protected byte extralength;
    protected byte datatype;
    protected short vbucket;
    protected int totalbody;
    protected int opaque;
    protected long cas;

    protected BaseMessage() {
    }

    protected BaseMessage(byte[] b) {
        this.magic = TapMagic.getMagicByByte(b[0]);
        this.opcode = TapOpcode.getOpcodeByByte(b[1]);
        this.keylength = this.decodeShort(b, 2);
        this.extralength = b[4];
        this.datatype = b[5];
        this.vbucket = this.decodeShort(b, 6);
        this.totalbody = this.decodeInt(b, 8);
        this.opaque = this.decodeInt(b, 12);
        this.cas = this.decodeLong(b, 16);
    }

    public final void setMagic(TapMagic m) {
        this.magic = m;
    }

    public final TapMagic getMagic() {
        return this.magic;
    }

    public final void setOpcode(TapOpcode o) {
        this.opcode = o;
    }

    public final TapOpcode getOpcode() {
        return this.opcode;
    }

    public final short getKeylength() {
        return this.keylength;
    }

    public final void setDatatype(byte d) {
        this.datatype = d;
    }

    public final byte getDatatype() {
        return this.datatype;
    }

    public final void setExtralength(byte e) {
        this.extralength = e;
    }

    public final byte getExtralength() {
        return this.extralength;
    }

    public final void setVbucket(short vb) {
        this.vbucket = vb;
    }

    public final short getVbucket() {
        return this.vbucket;
    }

    public final void setTotalbody(int t) {
        this.totalbody = t;
    }

    public final int getTotalbody() {
        return this.totalbody;
    }

    public final void setOpaque(int op) {
        this.opaque = op;
    }

    public final int getOpaque() {
        return this.opaque;
    }

    public final void setCas(long c) {
        this.cas = c;
    }

    public final long getCas() {
        return this.cas;
    }

    public final int getMessageLength() {
        return 24 + this.getTotalbody();
    }

    public abstract ByteBuffer getBytes();

    protected short decodeShort(byte[] data, int i) {
        return (short)((data[i] & 0xFF) << 8 | data[i + 1] & 0xFF);
    }

    protected int decodeInt(byte[] data, int i) {
        return (data[i] & 0xFF) << 24 | (data[i + 1] & 0xFF) << 16 | (data[i + 2] & 0xFF) << 8 | data[i + 3] & 0xFF;
    }

    protected int decodeIntHostOrder(byte[] data, int i) {
        return data[i] & 0xFF | (data[i + 1] & 0xFF) << 8 | (data[i + 2] & 0xFF) << 16 | (data[i + 3] & 0xFF) << 24;
    }

    protected long decodeLong(byte[] data, int i) {
        return ((long)data[i] & 0xFFL) << 56 | ((long)data[i + 1] & 0xFFL) << 48 | ((long)data[i + 2] & 0xFFL) << 40 | ((long)data[i + 3] & 0xFFL) << 32 | ((long)data[i + 4] & 0xFFL) << 24 | ((long)data[i + 5] & 0xFFL) << 16 | ((long)data[i + 6] & 0xFFL) << 8 | (long)data[i + 7] & 0xFFL;
    }
}

