/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.util.Strings;

public final class SearchScopeSyntaxChecker
extends SyntaxChecker {
    public static final SearchScopeSyntaxChecker INSTANCE = new SearchScopeSyntaxChecker("1.3.6.1.4.1.18060.0.4.1.0.10");

    private SearchScopeSyntaxChecker(String oid) {
        super(oid);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean isValidSyntax(Object value) {
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err((I18n)I18n.ERR_13210_SYNTAX_INVALID, (Object[])new Object[]{"null"}));
            }
            return false;
        }
        String strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])((byte[])value)) : value.toString());
        strValue = Strings.trim((String)Strings.toLowerCaseAscii((String)strValue));
        return "base".equals(strValue) || "one".equals(strValue) || "sub".equals(strValue);
    }

    public static final class Builder
    extends SyntaxChecker.SCBuilder<SearchScopeSyntaxChecker> {
        private Builder() {
            super("1.3.6.1.4.1.18060.0.4.1.0.10");
        }

        @Override
        public SearchScopeSyntaxChecker build() {
            return new SearchScopeSyntaxChecker(this.oid);
        }
    }
}

