/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway;

import org.apache.knox.gateway.i18n.messages.Message;
import org.apache.knox.gateway.i18n.messages.MessageLevel;
import org.apache.knox.gateway.i18n.messages.Messages;
import org.apache.knox.gateway.i18n.messages.StackTrace;

@Messages(logger="org.apache.knox.gateway")
public interface ClouderaManagerIntegrationMessages {
    @Message(level=MessageLevel.INFO, text="Monitoring Cloudera Manager descriptors in {0} ...")
    public void monitoringClouderaManagerDescriptor(String var1);

    @Message(level=MessageLevel.INFO, text="Monitoring Cloudera Manager descriptors is disabled.")
    public void disableMonitoringClouderaManagerDescriptor();

    @Message(level=MessageLevel.INFO, text="Parsing Cloudera Manager descriptor {0}. Looking up {1}...")
    public void parseClouderaManagerDescriptor(String var1, String var2);

    @Message(level=MessageLevel.INFO, text="Found Knox descriptors {0} in {1}")
    public void parsedClouderaManagerDescriptor(String var1, String var2);

    @Message(level=MessageLevel.INFO, text="Saved Knox descriptor {0}")
    public void savedSimpleDescriptorDescriptor(String var1);

    @Message(level=MessageLevel.INFO, text="Ignoring {0} Knox descriptor update because it did not change.")
    public void descriptorDidNotChange(String var1);

    @Message(level=MessageLevel.ERROR, text="Parsing Knox descriptor {0} failed: {1}")
    public void failedToParseDescriptor(String var1, String var2, @StackTrace(level=MessageLevel.DEBUG) Exception var3);

    @Message(level=MessageLevel.ERROR, text="Parsing XML configuration {0} failed: {1}")
    public void failedToParseXmlConfiguration(String var1, String var2, @StackTrace(level=MessageLevel.DEBUG) Exception var3);

    @Message(level=MessageLevel.ERROR, text="Error while monitoring CM descriptor {0}: {1}")
    public void failedToMonitorClouderaManagerDescriptor(String var1, String var2, @StackTrace(level=MessageLevel.DEBUG) Exception var3);

    @Message(level=MessageLevel.ERROR, text="Error while producing Knox descriptor: {0}")
    public void failedToProduceKnoxDescriptor(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.WARN, text="Service {0} is disabled. It will NOT be added in {1}")
    public void serviceDisabled(String var1, String var2);

    @Message(level=MessageLevel.INFO, text="Updated advanced service discovery configuration for {0}.")
    public void updatedAdvanceServiceDiscoverytConfiguration(String var1);
}

