#!/usr/bin/env node
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const fs_1 = require("fs");
const path_1 = require("path");
const purify_1 = require("./purify");
if (process.argv.length < 3 || process.argv.length > 4) {
    throw new Error(`
    purify should be called with either one or two arguments:

      purify input.js
      purify input.js output.js
  `);
}
const currentDir = process.cwd();
const inputFile = process.argv[2];
const tsOrJsRegExp = /\.(j|t)s$/;
if (!inputFile.match(tsOrJsRegExp)) {
    throw new Error(`Input file must be .js or .ts.`);
}
// Use provided output file, or add the .purify suffix before the extension.
const outputFile = process.argv[3]
    || inputFile.replace(tsOrJsRegExp, (subStr) => `.purify${subStr}`);
const purifyOutput = purify_1.purify(fs_1.readFileSync(path_1.join(currentDir, inputFile), 'UTF-8'));
fs_1.writeFileSync(path_1.join(currentDir, outputFile), purifyOutput);
console.log(`Emitted: ${outputFile}`);
//# sourceMappingURL=data:application/json;base64,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