/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.filter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.MimeType;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.io.IOUtils;
import org.apache.knox.gateway.filter.GatewayResponse;
import org.apache.knox.gateway.util.MimeTypes;

public abstract class GatewayResponseWrapper
extends HttpServletResponseWrapper
implements GatewayResponse {
    private static final String DEFAULT_MIME_TYPE = "*/*";

    public GatewayResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    @Override
    public MimeType getMimeType() {
        String contentType = this.getContentType();
        if (contentType == null) {
            contentType = DEFAULT_MIME_TYPE;
        }
        return MimeTypes.create((String)contentType, (String)this.getCharacterEncoding());
    }

    @Override
    public abstract OutputStream getRawOutputStream() throws IOException;

    @Override
    public void streamResponse(InputStream input) throws IOException {
        this.streamResponse(input, this.getRawOutputStream());
    }

    @Override
    public void streamResponse(InputStream input, OutputStream output) throws IOException {
        IOUtils.copy((InputStream)input, (OutputStream)output);
        output.close();
    }
}

