/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.request.search.filter;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.decorators.SearchRequestDecorator;
import org.apache.directory.api.ldap.codec.search.AttributeValueAssertionFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitApproxMatchFilter
extends GrammarAction<LdapMessageContainer<SearchRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(InitApproxMatchFilter.class);

    public InitApproxMatchFilter() {
        super("Init Approx Match filter Value");
    }

    public void action(LdapMessageContainer<SearchRequestDecorator> container) throws DecoderException {
        SearchRequestDecorator searchRequestDecorator = container.getMessage();
        AttributeValueAssertionFilter filter = new AttributeValueAssertionFilter(container.getTlvId(), 3);
        searchRequestDecorator.addCurrentFilter(filter);
        searchRequestDecorator.setTerminalFilter(filter);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_05142_INITIALIZE_APPROX_FILTER, (Object[])new Object[0]));
        }
    }
}

