/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A parcelRef references a parcel. Each parcel is identified by its \"parcelName\" and \"parcelVersion\", and the \"clusterName\" of the cluster that is using it. To operate on the parcel object, use the API with the those fields as parameters.")
public class ApiParcelRef {
    @SerializedName(value="clusterName")
    private String clusterName = null;
    @SerializedName(value="parcelName")
    private String parcelName = null;
    @SerializedName(value="parcelVersion")
    private String parcelVersion = null;

    public ApiParcelRef clusterName(String clusterName) {
        this.clusterName = clusterName;
        return this;
    }

    @ApiModelProperty(value="The name of the cluster that the parcel is used by.")
    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public ApiParcelRef parcelName(String parcelName) {
        this.parcelName = parcelName;
        return this;
    }

    @ApiModelProperty(value="The name of the parcel.")
    public String getParcelName() {
        return this.parcelName;
    }

    public void setParcelName(String parcelName) {
        this.parcelName = parcelName;
    }

    public ApiParcelRef parcelVersion(String parcelVersion) {
        this.parcelVersion = parcelVersion;
        return this;
    }

    @ApiModelProperty(value="The version of the parcel.")
    public String getParcelVersion() {
        return this.parcelVersion;
    }

    public void setParcelVersion(String parcelVersion) {
        this.parcelVersion = parcelVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiParcelRef apiParcelRef = (ApiParcelRef)o;
        return Objects.equals(this.clusterName, apiParcelRef.clusterName) && Objects.equals(this.parcelName, apiParcelRef.parcelName) && Objects.equals(this.parcelVersion, apiParcelRef.parcelVersion);
    }

    public int hashCode() {
        return Objects.hash(this.clusterName, this.parcelName, this.parcelVersion);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiParcelRef {\n");
        sb.append("    clusterName: ").append(this.toIndentedString(this.clusterName)).append("\n");
        sb.append("    parcelName: ").append(this.toIndentedString(this.parcelName)).append("\n");
        sb.append("    parcelVersion: ").append(this.toIndentedString(this.parcelVersion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

