/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.model.ranger;

import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import java.util.Locale;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.model.AbstractServiceModelGenerator;

public class RangerServiceModelGenerator
extends AbstractServiceModelGenerator {
    private static final String SERVICE = "RANGER";
    private static final String SERVICE_TYPE = "RANGER";
    private static final String ROLE_TYPE = "RANGER_ADMIN";

    @Override
    public boolean handles(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig) {
        return "RANGER".equals(service.getType()) && ROLE_TYPE.equals(role.getType());
    }

    @Override
    public ServiceModel generateService(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig) {
        String port;
        String scheme;
        String hostname = role.getHostRef().getHostname();
        boolean sslEnabled = Boolean.parseBoolean(this.getRoleConfigValue(roleConfig, "ssl_enabled"));
        if (sslEnabled) {
            scheme = "https";
            port = this.getServiceConfigValue(serviceConfig, "ranger_service_https_port");
        } else {
            scheme = "http";
            port = this.getServiceConfigValue(serviceConfig, "ranger_service_http_port");
        }
        return new ServiceModel(ServiceModel.Type.API, "RANGER", String.format(Locale.getDefault(), "%s://%s:%s", scheme, hostname, port));
    }
}

