/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.directory.mavibot.btree.NameRevision;
import org.apache.directory.mavibot.btree.PageIO;
import org.apache.directory.mavibot.btree.PersistedBTree;
import org.apache.directory.mavibot.btree.RecordManager;
import org.apache.directory.mavibot.btree.RevisionName;
import org.apache.directory.mavibot.btree.RevisionOffset;
import org.apache.directory.mavibot.btree.Tuple;
import org.apache.directory.mavibot.btree.TupleCursor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageReclaimer {
    private RecordManager rm;
    protected static final Logger LOG = LoggerFactory.getLogger(PageReclaimer.class);
    private boolean running = false;

    public PageReclaimer(RecordManager rm) {
        this.rm = rm;
    }

    void reclaim() {
        try {
            if (this.running) {
                return;
            }
            this.running = true;
            Set<String> managed = this.rm.getManagedTrees();
            for (String name : managed) {
                RevisionOffset ro;
                long rv;
                PersistedBTree tree = (PersistedBTree)this.rm.getManagedTree(name);
                long latestRev = tree.getRevision();
                TreeSet<Long> inUseRevisions = new TreeSet<Long>();
                if (tree != null) {
                    Iterator txnItr = tree.getReadTransactions().iterator();
                    while (txnItr.hasNext()) {
                        inUseRevisions.add(txnItr.next().getRevision());
                    }
                }
                List<RevisionOffset> copiedRevisions = this.getRevisions(name);
                long lastRemovedRev = -1L;
                ArrayList<Long> freeList = new ArrayList<Long>();
                Iterator<RevisionOffset> iterator = copiedRevisions.iterator();
                while (iterator.hasNext() && !inUseRevisions.contains(rv = (ro = iterator.next()).getRevision())) {
                    long[] offsets;
                    for (long l : offsets = ro.getOffsets()) {
                        freeList.add(l);
                    }
                    RevisionName key = new RevisionName(rv, name);
                    this.rm.copiedPageBtree.delete(key);
                    lastRemovedRev = rv;
                }
                if (lastRemovedRev != -1L && !tree.isAllowDuplicates()) {
                    NameRevision nr = new NameRevision(name, latestRev);
                    TupleCursor<NameRevision, Long> cursor = this.rm.btreeOfBtrees.browseFrom(nr);
                    ArrayList btreeHeaderOffsets = new ArrayList();
                    while (cursor.hasPrev()) {
                        Tuple<NameRevision, Long> t = cursor.prev();
                        this.rm.btreeOfBtrees.delete(t.getKey());
                        btreeHeaderOffsets.add(t.value);
                    }
                    cursor.close();
                    for (Long l : btreeHeaderOffsets) {
                        if (freeList.contains(l)) continue;
                        freeList.add(l);
                    }
                }
                for (Long offset : freeList) {
                    PageIO[] pageIos = this.rm.readPageIOs(offset, -1L);
                    for (PageIO pageIo : pageIos) {
                        this.rm.free(pageIo);
                    }
                }
            }
            this.running = false;
        }
        catch (Exception e) {
            this.running = false;
            this.rm.rollback();
            LOG.warn("Errors while reclaiming", e);
            throw new RuntimeException(e);
        }
    }

    private List<RevisionOffset> getRevisions(String name) throws Exception {
        TupleCursor<RevisionName, long[]> cursor = this.rm.copiedPageBtree.browse();
        ArrayList<RevisionOffset> lst = new ArrayList<RevisionOffset>();
        while (cursor.hasNext()) {
            Tuple<RevisionName, long[]> t = cursor.next();
            RevisionName rn = t.getKey();
            if (!name.equals(rn.getName())) continue;
            lst.add(new RevisionOffset(rn.getRevision(), t.getValue()));
        }
        cursor.close();
        return lst;
    }
}

