/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import org.apache.sshd.common.Property;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.server.config.SshServerConfigFileReader;

public final class SftpModuleProperties {
    public static final Property<Charset> NAME_DECODING_CHARSET = Property.charset((String)"sftp-name-decoding-charset", (Charset)StandardCharsets.UTF_8);
    public static final Property<Duration> SFTP_CHANNEL_OPEN_TIMEOUT = Property.duration((String)"sftp-channel-open-timeout", (Duration)Duration.ofSeconds(15L));
    public static final Property<Integer> POOL_SIZE = Property.integer((String)"sftp-fs-pool-size", (int)8);
    public static final Property<Duration> POOL_LIFE_TIME = Property.duration((String)"sftp-fs-pool-life-time", (Duration)Duration.ofSeconds(10L));
    public static final Property<Integer> POOL_CORE_SIZE = Property.integer((String)"sftp-fs-pool-core-size", (int)1);
    public static final Property<Integer> READ_BUFFER_SIZE = Property.integer((String)"sftp-fs-read-buffer-size");
    public static final Property<Integer> WRITE_BUFFER_SIZE = Property.integer((String)"sftp-fs-write-buffer-size");
    public static final Property<Duration> CONNECT_TIME = Property.duration((String)"sftp-fs-connect-time", (Duration)Duration.ofSeconds(15L));
    public static final Property<Duration> AUTH_TIME = Property.duration((String)"sftp-fs-auth-time", (Duration)Duration.ofSeconds(15L));
    public static final Property<Charset> NAME_DECODER_CHARSET = Property.charset((String)"sftp-fs-name-decoder-charset", (Charset)StandardCharsets.UTF_8);
    public static final Property<Integer> WRITE_CHUNK_SIZE = Property.integer((String)"sftp-client-write-chunk-size", (int)32704);
    public static final Property<Integer> COPY_BUF_SIZE = Property.integer((String)"sftp-channel-copy-buf-size", (int)8192);
    public static final Property<Boolean> APPEND_END_OF_LIST_INDICATOR = Property.bool((String)"sftp-append-eol-indicator", (boolean)true);
    public static final Property<Boolean> AUTO_FOLLOW_LINKS = Property.bool((String)"sftp-auto-follow-links", (boolean)true);
    public static final Property<String> CLIENT_EXTENSIONS = Property.string((String)"sftp-client-extensions");
    public static final Property<String> OPENSSH_EXTENSIONS = Property.string((String)"sftp-openssh-extensions");
    public static final Property<String> ACL_SUPPORTED_MASK = Property.string((String)"sftp-acl-supported-mask");
    public static final Property<String> NEWLINE_VALUE = Property.string((String)"sftp-newline", (String)IoUtils.EOL);
    public static final int MIN_READDATA_PACKET_LENGTH = 32768;
    public static final Property<Integer> MAX_READDATA_PACKET_LENGTH = Property.validating((Property)Property.integer((String)"sftp-max-readdata-packet-length", (int)64512), l -> ValidateUtils.checkTrue((l >= 32768 ? 1 : 0) != 0, (String)"Length is below min.: %d", (Object)l));
    public static final int MIN_WRITEDATA_PACKET_LENGTH = 32768;
    public static final Property<Integer> MAX_WRITEDATA_PACKET_LENGTH = Property.validating((Property)Property.integer((String)"sftp-max-writedata-packet-length", (int)262144), l -> ValidateUtils.checkTrue((l >= 32768 ? 1 : 0) != 0, (String)"Length is below min.: %d", (Object)l));
    public static final Property<Integer> MAX_OPEN_HANDLES_PER_SESSION = Property.integer((String)"max-open-handles-per-session", (int)0x7FFFFFFE);
    public static final int MIN_FILE_HANDLE_SIZE = 4;
    public static final int DEFAULT_FILE_HANDLE_SIZE = 4;
    public static final int MAX_FILE_HANDLE_SIZE = 64;
    public static final Property<Integer> FILE_HANDLE_SIZE = Property.validating((Property)Property.integer((String)"sftp-handle-size", (int)4), fhs -> {
        ValidateUtils.checkTrue((fhs >= 4 ? 1 : 0) != 0, (String)"File handle size too small: %d", (Object)fhs);
        ValidateUtils.checkTrue((fhs <= 64 ? 1 : 0) != 0, (String)"File handle size too big: %d", (Object)fhs);
    });
    public static final int MIN_FILE_HANDLE_ROUNDS = 1;
    public static final int DEFAULT_FILE_HANDLE_ROUNDS = 4;
    public static final int MAX_FILE_HANDLE_ROUNDS = 64;
    public static final Property<Integer> MAX_FILE_HANDLE_RAND_ROUNDS = Property.validating((Property)Property.integer((String)"sftp-handle-rand-max-rounds", (int)4), fhrr -> {
        ValidateUtils.checkTrue((fhrr >= 1 ? 1 : 0) != 0, (String)"File handle rounds too small: %d", (Object)fhrr);
        ValidateUtils.checkTrue((fhrr <= 64 ? 1 : 0) != 0, (String)"File handle rounds too big: %d", (Object)fhrr);
    });
    public static final Property<Integer> MAX_READDIR_DATA_SIZE = Property.integer((String)"sftp-max-readdir-data-size", (int)16384);
    public static final Property<Boolean> TOLERATE_EXCESS_DATA = Property.bool((String)"sftp-tolerate-excess-data", (boolean)false);
    public static final Property<Integer> SFTP_VERSION = SshServerConfigFileReader.SFTP_FORCED_VERSION_PROP;

    private SftpModuleProperties() {
        throw new UnsupportedOperationException("No instance");
    }
}

