/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.channels.Channel;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.client.ClientBuilder;
import org.apache.sshd.client.ClientFactoryManager;
import org.apache.sshd.client.auth.AuthenticationIdentitiesProvider;
import org.apache.sshd.client.auth.UserAuthFactory;
import org.apache.sshd.client.auth.keyboard.UserAuthKeyboardInteractiveFactory;
import org.apache.sshd.client.auth.keyboard.UserInteraction;
import org.apache.sshd.client.auth.password.PasswordIdentityProvider;
import org.apache.sshd.client.auth.password.UserAuthPasswordFactory;
import org.apache.sshd.client.auth.pubkey.UserAuthPublicKeyFactory;
import org.apache.sshd.client.config.hosts.HostConfigEntry;
import org.apache.sshd.client.config.hosts.HostConfigEntryResolver;
import org.apache.sshd.client.config.keys.ClientIdentity;
import org.apache.sshd.client.config.keys.ClientIdentityLoader;
import org.apache.sshd.client.config.keys.DefaultClientIdentitiesWatcher;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.future.DefaultConnectFuture;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.AbstractClientSession;
import org.apache.sshd.client.session.ClientConnectionServiceFactory;
import org.apache.sshd.client.session.ClientProxyConnector;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.session.ClientSessionCreator;
import org.apache.sshd.client.session.ClientUserAuthServiceFactory;
import org.apache.sshd.client.session.SessionFactory;
import org.apache.sshd.client.simple.AbstractSimpleClientSessionCreator;
import org.apache.sshd.client.simple.SimpleClient;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.ServiceFactory;
import org.apache.sshd.common.channel.ChannelFactory;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.PublicKeyEntry;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.helpers.AbstractFactoryManager;
import org.apache.sshd.common.io.IoConnectFuture;
import org.apache.sshd.common.io.IoConnector;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.session.helpers.AbstractSession;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.resource.PathResource;
import org.apache.sshd.common.util.net.SshdSocketAddress;

public class SshClient
extends AbstractFactoryManager
implements ClientFactoryManager,
ClientSessionCreator,
Closeable {
    public static final Factory<SshClient> DEFAULT_SSH_CLIENT_FACTORY = SshClient::new;
    public static final List<UserAuthFactory> DEFAULT_USER_AUTH_FACTORIES = Collections.unmodifiableList(Arrays.asList(UserAuthPublicKeyFactory.INSTANCE, UserAuthKeyboardInteractiveFactory.INSTANCE, UserAuthPasswordFactory.INSTANCE));
    public static final List<ServiceFactory> DEFAULT_SERVICE_FACTORIES = Collections.unmodifiableList(Arrays.asList(ClientUserAuthServiceFactory.INSTANCE, ClientConnectionServiceFactory.INSTANCE));
    protected IoConnector connector;
    protected SessionFactory sessionFactory;
    protected UserInteraction userInteraction;
    protected List<UserAuthFactory> userAuthFactories;
    private ClientProxyConnector proxyConnector;
    private ServerKeyVerifier serverKeyVerifier;
    private HostConfigEntryResolver hostConfigEntryResolver;
    private ClientIdentityLoader clientIdentityLoader;
    private KeyIdentityProvider keyIdentityProvider;
    private FilePasswordProvider filePasswordProvider;
    private PasswordIdentityProvider passwordIdentityProvider;
    private final List<Object> identities = new CopyOnWriteArrayList<Object>();
    private final AuthenticationIdentitiesProvider identitiesProvider;
    private final AtomicBoolean started = new AtomicBoolean(false);

    public SshClient() {
        this.identitiesProvider = AuthenticationIdentitiesProvider.wrapIdentities(this.identities);
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public ClientProxyConnector getClientProxyConnector() {
        return this.proxyConnector;
    }

    @Override
    public void setClientProxyConnector(ClientProxyConnector proxyConnector) {
        this.proxyConnector = proxyConnector;
    }

    @Override
    public ServerKeyVerifier getServerKeyVerifier() {
        return this.serverKeyVerifier;
    }

    @Override
    public void setServerKeyVerifier(ServerKeyVerifier serverKeyVerifier) {
        this.serverKeyVerifier = Objects.requireNonNull(serverKeyVerifier, "No server key verifier");
    }

    @Override
    public HostConfigEntryResolver getHostConfigEntryResolver() {
        return this.hostConfigEntryResolver;
    }

    @Override
    public void setHostConfigEntryResolver(HostConfigEntryResolver resolver) {
        this.hostConfigEntryResolver = Objects.requireNonNull(resolver, "No host configuration entry resolver");
    }

    @Override
    public FilePasswordProvider getFilePasswordProvider() {
        return this.filePasswordProvider;
    }

    @Override
    public void setFilePasswordProvider(FilePasswordProvider provider) {
        this.filePasswordProvider = Objects.requireNonNull(provider, "No file password provider");
    }

    @Override
    public ClientIdentityLoader getClientIdentityLoader() {
        return this.clientIdentityLoader;
    }

    @Override
    public void setClientIdentityLoader(ClientIdentityLoader loader) {
        this.clientIdentityLoader = Objects.requireNonNull(loader, "No client identity loader");
    }

    @Override
    public UserInteraction getUserInteraction() {
        return this.userInteraction;
    }

    @Override
    public void setUserInteraction(UserInteraction userInteraction) {
        this.userInteraction = userInteraction;
    }

    @Override
    public List<UserAuthFactory> getUserAuthFactories() {
        return this.userAuthFactories;
    }

    @Override
    public void setUserAuthFactories(List<UserAuthFactory> userAuthFactories) {
        this.userAuthFactories = ValidateUtils.checkNotNullAndNotEmpty(userAuthFactories, "No user auth factories", new Object[0]);
    }

    @Override
    public AuthenticationIdentitiesProvider getRegisteredIdentities() {
        return this.identitiesProvider;
    }

    @Override
    public PasswordIdentityProvider getPasswordIdentityProvider() {
        return this.passwordIdentityProvider;
    }

    @Override
    public void setPasswordIdentityProvider(PasswordIdentityProvider provider) {
        this.passwordIdentityProvider = provider;
    }

    @Override
    public void addPasswordIdentity(String password) {
        ValidateUtils.checkTrue(password != null && !password.isEmpty(), "No password provided");
        this.identities.add(password);
        if (this.log.isDebugEnabled()) {
            this.log.debug("addPasswordIdentity({}) {}", (Object)this, (Object)KeyUtils.getFingerPrint(password));
        }
    }

    @Override
    public String removePasswordIdentity(String password) {
        if (GenericUtils.isEmpty(password)) {
            return null;
        }
        int index = AuthenticationIdentitiesProvider.findIdentityIndex(this.identities, AuthenticationIdentitiesProvider.PASSWORD_IDENTITY_COMPARATOR, password);
        if (index >= 0) {
            return (String)this.identities.remove(index);
        }
        return null;
    }

    @Override
    public void addPublicKeyIdentity(KeyPair kp) {
        Objects.requireNonNull(kp, "No key-pair to add");
        Objects.requireNonNull(kp.getPublic(), "No public key");
        Objects.requireNonNull(kp.getPrivate(), "No private key");
        this.identities.add(kp);
        if (this.log.isDebugEnabled()) {
            this.log.debug("addPublicKeyIdentity({}) {}", (Object)this, (Object)KeyUtils.getFingerPrint(kp.getPublic()));
        }
    }

    @Override
    public KeyPair removePublicKeyIdentity(KeyPair kp) {
        if (kp == null) {
            return null;
        }
        int index = AuthenticationIdentitiesProvider.findIdentityIndex(this.identities, AuthenticationIdentitiesProvider.KEYPAIR_IDENTITY_COMPARATOR, kp);
        if (index >= 0) {
            return (KeyPair)this.identities.remove(index);
        }
        return null;
    }

    @Override
    public KeyIdentityProvider getKeyIdentityProvider() {
        return this.keyIdentityProvider;
    }

    @Override
    public void setKeyIdentityProvider(KeyIdentityProvider keyIdentityProvider) {
        this.keyIdentityProvider = keyIdentityProvider;
    }

    @Override
    protected void checkConfig() {
        SshAgentFactory agentFactory;
        super.checkConfig();
        Objects.requireNonNull(this.getForwarderFactory(), "ForwarderFactory not set");
        Objects.requireNonNull(this.getServerKeyVerifier(), "ServerKeyVerifier not set");
        Objects.requireNonNull(this.getHostConfigEntryResolver(), "HostConfigEntryResolver not set");
        Objects.requireNonNull(this.getClientIdentityLoader(), "ClientIdentityLoader not set");
        Objects.requireNonNull(this.getFilePasswordProvider(), "FilePasswordProvider not set");
        KeyIdentityProvider defaultIdentities = this.getKeyIdentityProvider();
        if (defaultIdentities == null) {
            DefaultClientIdentitiesWatcher idsWatcher = new DefaultClientIdentitiesWatcher(this::getClientIdentityLoader, this::getFilePasswordProvider);
            this.setKeyIdentityProvider(idsWatcher);
        }
        if ((agentFactory = this.getAgentFactory()) != null) {
            List<ChannelFactory> forwarders = ValidateUtils.checkNotNullAndNotEmpty(agentFactory.getChannelForwardingFactories(this), "No agent channel forwarding factories for %s", agentFactory);
            List<ChannelFactory> factories = this.getChannelFactories();
            if (GenericUtils.isEmpty(factories)) {
                factories = forwarders;
            } else {
                ArrayList<ChannelFactory> factories2 = new ArrayList<ChannelFactory>(factories.size() + forwarders.size());
                factories2.addAll(factories);
                factories2.addAll(forwarders);
                factories = factories2;
            }
            this.setChannelFactories(factories);
        }
        if (GenericUtils.isEmpty(this.getServiceFactories())) {
            this.setServiceFactories(DEFAULT_SERVICE_FACTORIES);
        }
        if (GenericUtils.isEmpty(this.getUserAuthFactories())) {
            this.setUserAuthFactories(DEFAULT_USER_AUTH_FACTORIES);
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public void start() {
        if (this.isClosed()) {
            throw new IllegalStateException("Can not start the client again");
        }
        if (this.isStarted()) {
            return;
        }
        this.checkConfig();
        if (this.sessionFactory == null) {
            this.sessionFactory = this.createSessionFactory();
        }
        this.setupSessionTimeout(this.sessionFactory);
        this.connector = this.createConnector();
        this.started.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (!this.started.getAndSet(false)) {
            return;
        }
        try {
            long maxWait = this.getLongProperty("stop-wait-time", DEFAULT_STOP_WAIT_TIME);
            boolean successful = this.close(true).await(maxWait);
            if (!successful) {
                throw new SocketTimeoutException("Failed to receive closure confirmation within " + maxWait + " millis");
            }
        }
        catch (IOException e) {
            this.log.warn(e.getClass().getSimpleName() + " while stopping client: " + e.getMessage());
            if (this.log.isDebugEnabled()) {
                this.log.warn("Stop exception details", (Throwable)e);
            }
        }
        finally {
            this.clearAttributes();
        }
    }

    public void open() throws IOException {
        this.start();
    }

    @Override
    protected Closeable getInnerCloseable() {
        String closeId = this.toString();
        return this.builder().run(closeId, () -> this.removeSessionTimeout(this.sessionFactory)).sequential(this.connector, this.ioServiceFactory).run(closeId, () -> {
            this.connector = null;
            this.ioServiceFactory = null;
            if (this.shutdownExecutor && this.executor != null && !this.executor.isShutdown()) {
                try {
                    this.executor.shutdownNow();
                }
                finally {
                    this.executor = null;
                }
            }
        }).build();
    }

    @Override
    public ConnectFuture connect(String username, String host, int port, AttributeRepository context, SocketAddress localAddress) throws IOException {
        HostConfigEntryResolver resolver = this.getHostConfigEntryResolver();
        HostConfigEntry entry = resolver.resolveEffectiveHost(host, port, localAddress, username, context);
        if (entry == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("connect({}@{}:{}) no overrides", new Object[]{username, host, port});
            }
            entry = SshdSocketAddress.isIPv6Address(host) ? new HostConfigEntry("", host, port, username) : new HostConfigEntry(host, host, port, username);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("connect({}@{}:{}) effective: {}", new Object[]{username, host, port, entry});
        }
        return this.connect(entry, context, localAddress);
    }

    @Override
    public ConnectFuture connect(String username, SocketAddress targetAddress, AttributeRepository context, SocketAddress localAddress) throws IOException {
        Objects.requireNonNull(targetAddress, "No target address");
        if (targetAddress instanceof InetSocketAddress) {
            InetSocketAddress inetAddress = (InetSocketAddress)targetAddress;
            String host = ValidateUtils.checkNotNullAndNotEmpty(inetAddress.getHostString(), "No host");
            int port = inetAddress.getPort();
            ValidateUtils.checkTrue(port > 0, "Invalid port: %d", port);
            HostConfigEntryResolver resolver = this.getHostConfigEntryResolver();
            HostConfigEntry entry = resolver.resolveEffectiveHost(host, port, localAddress, username, context);
            if (entry == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("connect({}@{}:{}) no overrides", new Object[]{username, host, port});
                }
                return this.doConnect(username, targetAddress, context, localAddress, KeyIdentityProvider.EMPTY_KEYS_PROVIDER, true);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("connect({}@{}:{}) effective: {}", new Object[]{username, host, port, entry});
            }
            return this.connect(entry, context, localAddress);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("connect({}@{}) not an InetSocketAddress: {}", new Object[]{username, targetAddress, targetAddress.getClass().getName()});
        }
        return this.doConnect(username, targetAddress, context, localAddress, KeyIdentityProvider.EMPTY_KEYS_PROVIDER, true);
    }

    @Override
    public ConnectFuture connect(HostConfigEntry hostConfig, AttributeRepository context, SocketAddress localAddress) throws IOException {
        Objects.requireNonNull(hostConfig, "No host configuration");
        String host = ValidateUtils.checkNotNullAndNotEmpty(hostConfig.getHostName(), "No target host");
        int port = hostConfig.getPort();
        ValidateUtils.checkTrue(port > 0, "Invalid port: %d", port);
        Collection<String> hostIds = hostConfig.getIdentities();
        List idFiles = GenericUtils.isEmpty(hostIds) ? Collections.emptyList() : (Collection)hostIds.stream().map(x$0 -> Paths.get(x$0, new String[0])).map(PathResource::new).collect(Collectors.toCollection(() -> new ArrayList(hostIds.size())));
        KeyIdentityProvider keys = this.preloadClientIdentities(idFiles);
        return this.doConnect(hostConfig.getUsername(), new InetSocketAddress(host, port), context, localAddress, keys, !hostConfig.isIdentitiesOnly());
    }

    protected KeyIdentityProvider preloadClientIdentities(Collection<? extends NamedResource> locations) throws IOException {
        return GenericUtils.isEmpty(locations) ? KeyIdentityProvider.EMPTY_KEYS_PROVIDER : ClientIdentityLoader.asKeyIdentityProvider(Objects.requireNonNull(this.getClientIdentityLoader(), "No ClientIdentityLoader"), locations, this.getFilePasswordProvider(), this.getBooleanProperty("ignore-invalid-identities", true));
    }

    protected ConnectFuture doConnect(String username, SocketAddress targetAddress, AttributeRepository context, SocketAddress localAddress, KeyIdentityProvider identities, boolean useDefaultIdentities) throws IOException {
        if (this.connector == null) {
            throw new IllegalStateException("SshClient not started. Please call start() method before connecting to a server");
        }
        DefaultConnectFuture connectFuture = new DefaultConnectFuture(username + "@" + targetAddress, null);
        SshFutureListener<IoConnectFuture> listener = this.createConnectCompletionListener(connectFuture, username, targetAddress, identities, useDefaultIdentities);
        IoConnectFuture connectingFuture = this.connector.connect(targetAddress, context, localAddress);
        connectingFuture.addListener(listener);
        return connectFuture;
    }

    protected SshFutureListener<IoConnectFuture> createConnectCompletionListener(final ConnectFuture connectFuture, final String username, final SocketAddress address, final KeyIdentityProvider identities, final boolean useDefaultIdentities) {
        return new SshFutureListener<IoConnectFuture>(){

            @Override
            public void operationComplete(IoConnectFuture future) {
                if (future.isCanceled()) {
                    connectFuture.cancel();
                    return;
                }
                Throwable t = future.getException();
                if (t != null) {
                    if (SshClient.this.log.isDebugEnabled()) {
                        SshClient.this.log.debug("operationComplete({}@{}) failed ({}): {}", new Object[]{username, address, t.getClass().getSimpleName(), t.getMessage()});
                    }
                    connectFuture.setException(t);
                } else {
                    IoSession ioSession = future.getSession();
                    try {
                        SshClient.this.onConnectOperationComplete(ioSession, connectFuture, username, address, identities, useDefaultIdentities);
                    }
                    catch (RuntimeException e) {
                        SshClient.this.log.warn("operationComplete({}@{}) failed ({}) to signal completion of session={}: {}", new Object[]{username, address, e.getClass().getSimpleName(), ioSession, e.getMessage()});
                        if (SshClient.this.log.isDebugEnabled()) {
                            SshClient.this.log.debug("operationComplete(" + username + "@" + address + ") session=" + ioSession + " completion signal failure details", (Throwable)e);
                        }
                        connectFuture.setException(e);
                        ioSession.close(true);
                    }
                }
            }

            public String toString() {
                return "ConnectCompletionListener[" + username + "@" + address + "]";
            }
        };
    }

    protected void onConnectOperationComplete(IoSession ioSession, ConnectFuture connectFuture, String username, SocketAddress address, KeyIdentityProvider identities, boolean useDefaultIdentities) {
        AbstractClientSession session = (AbstractClientSession)AbstractSession.getSession(ioSession);
        session.setUsername(username);
        session.setConnectAddress(address);
        if (useDefaultIdentities) {
            this.setupDefaultSessionIdentities(session, identities);
        } else {
            session.setKeyIdentityProvider(identities == null ? KeyIdentityProvider.EMPTY_KEYS_PROVIDER : identities);
        }
        connectFuture.setSession(session);
    }

    protected void setupDefaultSessionIdentities(ClientSession session, KeyIdentityProvider extraIdentities) {
        PasswordIdentityProvider passClient;
        PasswordIdentityProvider passSession;
        KeyIdentityProvider kpEffective;
        KeyIdentityProvider kpClient;
        boolean debugEnabled = this.log.isDebugEnabled();
        KeyIdentityProvider kpSession = session.getKeyIdentityProvider();
        if (GenericUtils.isSameReference(kpSession, kpClient = this.getKeyIdentityProvider()) && debugEnabled) {
            this.log.debug("setupDefaultSessionIdentities({}) key identity provider override in session listener", (Object)session);
        }
        if (!GenericUtils.isSameReference(kpSession, kpEffective = KeyIdentityProvider.resolveKeyIdentityProvider(extraIdentities, kpSession))) {
            if (debugEnabled) {
                this.log.debug("setupDefaultSessionIdentities({}) key identity provider enhanced", (Object)session);
            }
            session.setKeyIdentityProvider(kpEffective);
        }
        if (!GenericUtils.isSameReference(passSession = session.getPasswordIdentityProvider(), passClient = this.getPasswordIdentityProvider()) && debugEnabled) {
            this.log.debug("setupDefaultSessionIdentities({}) password provider override", (Object)session);
        }
        AuthenticationIdentitiesProvider idsClient = this.getRegisteredIdentities();
        boolean traceEnabled = this.log.isTraceEnabled();
        Iterator<?> iter = GenericUtils.iteratorOf(idsClient == null ? null : idsClient.loadIdentities());
        while (iter.hasNext()) {
            Object id = iter.next();
            if (id instanceof String) {
                if (traceEnabled) {
                    this.log.trace("setupDefaultSessionIdentities({}) add password fingerprint={}", (Object)session, (Object)KeyUtils.getFingerPrint(id.toString()));
                }
                session.addPasswordIdentity((String)id);
                continue;
            }
            if (id instanceof KeyPair) {
                KeyPair kp = (KeyPair)id;
                if (traceEnabled) {
                    this.log.trace("setupDefaultSessionIdentities({}) add identity type={}, fingerprint={}", new Object[]{session, KeyUtils.getKeyType(kp), KeyUtils.getFingerPrint(kp.getPublic())});
                }
                session.addPublicKeyIdentity(kp);
                continue;
            }
            if (!debugEnabled) continue;
            this.log.debug("setupDefaultSessionIdentities({}) ignored identity={}", (Object)session, id);
        }
    }

    protected IoConnector createConnector() {
        return this.getIoServiceFactory().createConnector(this.getSessionFactory());
    }

    protected SessionFactory createSessionFactory() {
        return new SessionFactory(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + Integer.toHexString(this.hashCode()) + "]";
    }

    public static SimpleClient setUpDefaultSimpleClient() {
        SshClient client = SshClient.setUpDefaultClient();
        client.start();
        return SshClient.wrapAsSimpleClient(client);
    }

    public static SimpleClient wrapAsSimpleClient(final SshClient client) {
        Objects.requireNonNull(client, "No client instance");
        Channel channel = new Channel(){

            @Override
            public boolean isOpen() {
                return client.isOpen();
            }

            @Override
            public void close() throws IOException {
                Exception err = null;
                try {
                    client.close();
                }
                catch (Exception e) {
                    err = GenericUtils.accumulateException(err, e);
                }
                try {
                    client.stop();
                }
                catch (Exception e) {
                    err = GenericUtils.accumulateException(err, e);
                }
                if (err != null) {
                    if (err instanceof IOException) {
                        throw (IOException)err;
                    }
                    throw new IOException(err);
                }
            }
        };
        return AbstractSimpleClientSessionCreator.wrap(client, channel);
    }

    public static SshClient setUpDefaultClient() {
        ClientBuilder builder = ClientBuilder.builder();
        return (SshClient)builder.build();
    }

    public static <C extends SshClient> C setKeyPairProvider(C client, boolean strict, boolean supportedOnly, FilePasswordProvider provider, LinkOption ... options) throws IOException, GeneralSecurityException {
        return SshClient.setKeyPairProvider(client, PublicKeyEntry.getDefaultKeysFolderPath(), strict, supportedOnly, provider, options);
    }

    public static <C extends SshClient> C setKeyPairProvider(C client, Path dir, boolean strict, boolean supportedOnly, FilePasswordProvider provider, LinkOption ... options) throws IOException, GeneralSecurityException {
        KeyPairProvider kpp = ClientIdentity.loadDefaultKeyPairProvider(dir, strict, supportedOnly, provider, options);
        if (kpp != null) {
            client.setKeyIdentityProvider(kpp);
        }
        return client;
    }
}

