/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.jcl;

import org.apache.commons.logging.Log;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.PaxLoggingManager;
import org.ops4j.pax.logging.PaxLoggingManagerAwareLogger;
import org.ops4j.pax.logging.spi.support.FallbackLogFactory;
import org.osgi.framework.FrameworkUtil;

public class JclLogger
implements Log,
PaxLoggingManagerAwareLogger {
    public static final String JCL_FQCN = JclLogger.class.getName();
    private String m_name;
    private PaxLogger m_delegate;

    public JclLogger(String name, PaxLogger delegate) {
        this.m_name = name;
        this.m_delegate = delegate;
    }

    @Override
    public void setPaxLoggingManager(PaxLoggingManager paxLoggingManager) {
        this.m_delegate = paxLoggingManager == null ? FallbackLogFactory.createFallbackLog(FrameworkUtil.getBundle(Log.class), this.m_name) : paxLoggingManager.getLogger(this.m_name, JCL_FQCN);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.m_delegate.isDebugEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.m_delegate.isErrorEnabled();
    }

    @Override
    public boolean isFatalEnabled() {
        return this.m_delegate.isFatalEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.m_delegate.isInfoEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.m_delegate.isTraceEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.m_delegate.isWarnEnabled();
    }

    @Override
    public void trace(Object message) {
        this.m_delegate.trace(message == null ? null : message.toString(), null);
    }

    @Override
    public void trace(Object message, Throwable t) {
        this.m_delegate.trace(message == null ? null : message.toString(), t);
    }

    @Override
    public void debug(Object message) {
        this.m_delegate.debug(message == null ? null : message.toString(), null);
    }

    @Override
    public void debug(Object message, Throwable t) {
        this.m_delegate.debug(message == null ? null : message.toString(), t);
    }

    @Override
    public void info(Object message) {
        this.m_delegate.inform(message == null ? null : message.toString(), null);
    }

    @Override
    public void info(Object message, Throwable t) {
        this.m_delegate.inform(message == null ? null : message.toString(), t);
    }

    @Override
    public void warn(Object message) {
        this.m_delegate.warn(message == null ? null : message.toString(), null);
    }

    @Override
    public void warn(Object message, Throwable t) {
        this.m_delegate.warn(message == null ? null : message.toString(), t);
    }

    @Override
    public void error(Object message) {
        this.m_delegate.error(message == null ? null : message.toString(), null);
    }

    @Override
    public void error(Object message, Throwable t) {
        this.m_delegate.error(message == null ? null : message.toString(), t);
    }

    @Override
    public void fatal(Object message) {
        this.m_delegate.fatal(message == null ? null : message.toString(), null);
    }

    @Override
    public void fatal(Object message, Throwable t) {
        this.m_delegate.fatal(message == null ? null : message.toString(), t);
    }
}

