/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.resolver;

import java.util.Map;
import org.apache.karaf.features.internal.resolver.BaseClause;
import org.apache.karaf.features.internal.resolver.CapabilitySet;
import org.apache.karaf.features.internal.resolver.SimpleFilter;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class RequirementImpl
extends BaseClause
implements Requirement {
    private final Resource resource;
    private final String namespace;
    private final SimpleFilter filter;
    private final boolean optional;
    private final Map<String, String> dirs;
    private final Map<String, Object> attrs;

    public RequirementImpl(Resource resource, String namespace, Map<String, String> dirs, Map<String, Object> attrs, SimpleFilter filter) {
        this.resource = resource;
        this.namespace = namespace;
        this.dirs = dirs;
        this.attrs = attrs;
        this.filter = filter;
        this.optional = "optional".equals(this.dirs.get("resolution"));
    }

    public RequirementImpl(Resource resource, String namespace, Map<String, String> dirs, Map<String, Object> attrs) {
        this(resource, namespace, dirs, attrs, SimpleFilter.convert(attrs));
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public Map<String, String> getDirectives() {
        return this.dirs;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attrs;
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    public boolean matches(Capability cap) {
        return CapabilitySet.matches(cap, this.getFilter());
    }

    public boolean isOptional() {
        return this.optional;
    }

    public SimpleFilter getFilter() {
        return this.filter;
    }
}

