/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.jline;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.gogo.jline.Posix;
import org.apache.felix.gogo.jline.Shell;
import org.apache.felix.gogo.runtime.EOFError;
import org.apache.felix.gogo.runtime.Parser;
import org.apache.felix.gogo.runtime.SyntaxError;
import org.apache.felix.gogo.runtime.Token;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Function;
import org.jline.reader.LineReader;
import org.jline.reader.impl.DefaultHighlighter;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.jline.utils.WCWidth;

public class Highlighter
extends DefaultHighlighter {
    public static final String DEFAULT_HIGHLIGHTER_COLORS = "rs=35:st=32:nu=32:co=32:va=36:vn=36:fu=94:bf=91:re=90";
    private final CommandSession session;

    public Highlighter(CommandSession session) {
        this.session = session;
    }

    public AttributedString highlight(LineReader reader, String buffer) {
        try {
            Parser.Program program = null;
            List<Token> tokens = null;
            List<Parser.Statement> statements = null;
            String repaired = buffer;
            while (program == null) {
                try {
                    Parser parser = new Parser(repaired);
                    program = parser.program();
                    tokens = parser.tokens();
                    statements = parser.statements();
                }
                catch (EOFError e) {
                    if ((repaired = repaired + " " + e.repair()).length() <= buffer.length() + 1024) continue;
                    return new AttributedStringBuilder().append((CharSequence)buffer).toAttributedString();
                }
            }
            Map<String, String> colors = Posix.getColorMap(this.session, "HIGHLIGHTER", DEFAULT_HIGHLIGHTER_COLORS);
            int underlineStart = -1;
            int underlineEnd = -1;
            int negativeStart = -1;
            int negativeEnd = -1;
            String search = reader.getSearchTerm();
            if (search != null && search.length() > 0 && (underlineStart = buffer.indexOf(search)) >= 0) {
                underlineEnd = underlineStart + search.length() - 1;
            }
            if (reader.getRegionActive() != LineReader.RegionType.NONE) {
                negativeStart = reader.getRegionMark();
                if (negativeStart > (negativeEnd = reader.getBuffer().cursor())) {
                    int x = negativeEnd;
                    negativeEnd = negativeStart;
                    negativeStart = x;
                }
                if (reader.getRegionActive() == LineReader.RegionType.LINE) {
                    while (negativeStart > 0 && reader.getBuffer().atChar(negativeStart - 1) != 10) {
                        --negativeStart;
                    }
                    while (negativeEnd < reader.getBuffer().length() - 1 && reader.getBuffer().atChar(negativeEnd + 1) != 10) {
                        ++negativeEnd;
                    }
                }
            }
            Type[] types = new Type[repaired.length()];
            Arrays.fill((Object[])types, (Object)Type.Unknown);
            int cur = 0;
            for (Token token : tokens) {
                if (token.start() >= buffer.length()) break;
                if (token.start() > cur) {
                    cur = token.start();
                }
                Parser.Statement statement = null;
                for (int i = statements.size() - 1; i >= 0; --i) {
                    Parser.Statement s = statements.get(i);
                    if (s.start() > cur || cur >= s.start() + s.length()) continue;
                    statement = s;
                    break;
                }
                Type type = Type.Unknown;
                if (Token.eq(token, "{") || Token.eq(token, "}") || Token.eq(token, "(") || Token.eq(token, ")") || Token.eq(token, "[") || Token.eq(token, "]") || Token.eq(token, "|") || Token.eq(token, ";") || Token.eq(token, "=")) {
                    type = Type.Reserved;
                } else if (token.charAt(0) == '\'' || token.charAt(0) == '\"') {
                    type = Type.String;
                } else if (token.toString().matches("^[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?$")) {
                    type = Type.Number;
                } else if (token.charAt(0) == '$') {
                    type = Type.Variable;
                } else if (((Set)this.session.get(".constants")).contains(token.toString()) || Token.eq(token, "null") || Token.eq(token, "false") || Token.eq(token, "true")) {
                    type = Type.Constant;
                } else {
                    boolean isAssign;
                    boolean isFirst = statement != null && statement.tokens().size() > 0 && token == statement.tokens().get(0);
                    boolean isThirdWithNext = statement != null && statement.tokens().size() > 3 && token == statement.tokens().get(2);
                    boolean bl = isAssign = statement != null && statement.tokens().size() > 1 && Token.eq(statement.tokens().get(1), "=");
                    if (isFirst && isAssign) {
                        type = Type.VariableName;
                    }
                    if (isFirst && !isAssign || isAssign && isThirdWithNext) {
                        Object v = this.session.get(Shell.resolve(this.session, token.toString()));
                        type = v instanceof Function ? Type.Function : Type.BadFunction;
                    }
                }
                Arrays.fill((Object[])types, token.start(), Math.min(token.start() + token.length(), types.length), (Object)type);
                cur = Math.min(token.start() + token.length(), buffer.length());
            }
            if (buffer.length() < repaired.length()) {
                Arrays.fill((Object[])types, buffer.length(), repaired.length(), (Object)Type.Repair);
            }
            AttributedStringBuilder sb = new AttributedStringBuilder();
            for (int i = 0; i < repaired.length(); ++i) {
                char c;
                sb.style(AttributedStyle.DEFAULT);
                this.applyStyle(sb, colors, types[i]);
                if (i >= underlineStart && i <= underlineEnd) {
                    sb.style(sb.style().underline());
                }
                if (i >= negativeStart && i <= negativeEnd) {
                    sb.style(sb.style().inverse());
                }
                if ((c = repaired.charAt(i)) == '\t' || c == '\n') {
                    sb.append(c);
                    continue;
                }
                if (c < ' ') {
                    sb.style(sb.style().inverseNeg()).append('^').append((char)(c + 64)).style(sb.style().inverseNeg());
                    continue;
                }
                int w = WCWidth.wcwidth((int)c);
                if (w <= 0) continue;
                sb.append(c);
            }
            return sb.toAttributedString();
        }
        catch (SyntaxError e) {
            return super.highlight(reader, buffer);
        }
    }

    private void applyStyle(AttributedStringBuilder sb, Map<String, String> colors, Type type) {
        String col = colors.get(type.color);
        if (col != null && !col.isEmpty()) {
            sb.appendAnsi("\u001b[" + col + "m");
        }
    }

    static enum Type {
        Reserved("rs"),
        String("st"),
        Number("nu"),
        Variable("va"),
        VariableName("vn"),
        Function("fu"),
        BadFunction("bf"),
        Constant("co"),
        Unknown("un"),
        Repair("re");

        private final String color;

        private Type(String color) {
            this.color = color;
        }
    }
}

