/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.dispatch;

import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.apache.felix.http.base.internal.context.ExtServletContext;
import org.apache.felix.http.base.internal.dispatch.RequestInfo;
import org.apache.felix.http.base.internal.handler.HttpSessionWrapper;
import org.apache.felix.http.base.internal.util.UriUtils;
import org.osgi.service.useradmin.Authorization;

final class ServletRequestWrapper
extends HttpServletRequestWrapper {
    private final DispatcherType type;
    private final RequestInfo requestInfo;
    private final ExtServletContext servletContext;
    private final long contextId;
    private final boolean asyncSupported;

    public ServletRequestWrapper(HttpServletRequest req, ExtServletContext servletContext, RequestInfo requestInfo, DispatcherType type, Long contextId, boolean asyncSupported) {
        super(req);
        this.asyncSupported = asyncSupported;
        this.servletContext = servletContext;
        this.requestInfo = requestInfo;
        this.type = type;
        this.contextId = contextId;
    }

    public Object getAttribute(String name) {
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        if (this.isInclusionDispatcher()) {
            if ("javax.servlet.include.request_uri".equals(name)) {
                return UriUtils.concat(request.getContextPath(), this.requestInfo.requestURI);
            }
            if ("javax.servlet.include.context_path".equals(name)) {
                return request.getContextPath();
            }
            if ("javax.servlet.include.servlet_path".equals(name)) {
                return this.requestInfo.servletPath;
            }
            if ("javax.servlet.include.path_info".equals(name)) {
                return this.requestInfo.pathInfo;
            }
            if ("javax.servlet.include.query_string".equals(name)) {
                return this.requestInfo.queryString;
            }
        } else if (this.isForwardingDispatcher()) {
            if ("javax.servlet.forward.request_uri".equals(name)) {
                return super.getRequestURI();
            }
            if ("javax.servlet.forward.context_path".equals(name)) {
                return request.getContextPath();
            }
            if ("javax.servlet.forward.servlet_path".equals(name)) {
                return super.getServletPath();
            }
            if ("javax.servlet.forward.path_info".equals(name)) {
                return super.getPathInfo();
            }
            if ("javax.servlet.forward.query_string".equals(name)) {
                return super.getQueryString();
            }
        }
        return super.getAttribute(name);
    }

    public String getAuthType() {
        String authType = (String)this.getAttribute("org.osgi.service.http.authentication.type");
        if (authType == null) {
            authType = super.getAuthType();
        }
        return authType;
    }

    public String getContextPath() {
        return this.getServletContext().getContextPath();
    }

    public DispatcherType getDispatcherType() {
        return this.type == null ? super.getDispatcherType() : this.type;
    }

    public String getPathInfo() {
        if (this.isInclusionDispatcher()) {
            return super.getPathInfo();
        }
        return this.requestInfo.pathInfo;
    }

    public String getPathTranslated() {
        String info = this.getPathInfo();
        return null == info ? null : this.getRealPath(info);
    }

    public String getRemoteUser() {
        String remoteUser = (String)this.getAttribute("org.osgi.service.http.authentication.remote.user");
        if (remoteUser != null) {
            return remoteUser;
        }
        return super.getRemoteUser();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        boolean relPath;
        if (path == null) {
            return null;
        }
        boolean bl = relPath = !path.startsWith("/") && !"".equals(path);
        if (relPath) {
            path = UriUtils.concat(this.getServletPath(), path);
        }
        return this.servletContext.getRequestDispatcher(path);
    }

    public String getRequestURI() {
        if (this.isInclusionDispatcher()) {
            return super.getRequestURI();
        }
        return UriUtils.concat(this.getContextPath(), this.requestInfo.requestURI);
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public String getServletPath() {
        if (this.isInclusionDispatcher()) {
            return super.getServletPath();
        }
        return this.requestInfo.servletPath;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        HttpSession session = super.getSession(create);
        if (session == null) {
            return null;
        }
        if (!create && !HttpSessionWrapper.hasSession(this.contextId, session)) {
            return null;
        }
        return new HttpSessionWrapper(this.contextId, session, this.servletContext, false);
    }

    public boolean isUserInRole(String role) {
        Authorization authorization = (Authorization)this.getAttribute("org.osgi.service.useradmin.authorization");
        if (authorization != null) {
            return authorization.hasRole(role);
        }
        return super.isUserInRole(role);
    }

    public void setAttribute(String name, Object value) {
        if (value == null) {
            this.removeAttribute(name);
        }
        Object oldValue = this.getAttribute(name);
        super.setAttribute(name, value);
        if (this.servletContext.getServletRequestAttributeListener() != null) {
            if (oldValue == null) {
                this.servletContext.getServletRequestAttributeListener().attributeAdded(new ServletRequestAttributeEvent((ServletContext)this.servletContext, (ServletRequest)this, name, value));
            } else {
                this.servletContext.getServletRequestAttributeListener().attributeReplaced(new ServletRequestAttributeEvent((ServletContext)this.servletContext, (ServletRequest)this, name, oldValue));
            }
        }
    }

    public void removeAttribute(String name) {
        Object oldValue = this.getAttribute(name);
        if (oldValue != null) {
            super.removeAttribute(name);
            if (this.servletContext.getServletRequestAttributeListener() != null) {
                this.servletContext.getServletRequestAttributeListener().attributeRemoved(new ServletRequestAttributeEvent((ServletContext)this.servletContext, (ServletRequest)this, name, oldValue));
            }
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "->" + super.getRequest();
    }

    private boolean isForwardingDispatcher() {
        return DispatcherType.FORWARD == this.type && this.requestInfo != null;
    }

    private boolean isInclusionDispatcher() {
        return DispatcherType.INCLUDE == this.type && this.requestInfo != null;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        if (!this.asyncSupported) {
            throw new IllegalStateException();
        }
        return super.startAsync();
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        if (!this.asyncSupported) {
            throw new IllegalStateException();
        }
        return super.startAsync(servletRequest, servletResponse);
    }

    public boolean isAsyncSupported() {
        return this.asyncSupported;
    }
}

