/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.node;

import io.burt.jmespath.Adapter;
import io.burt.jmespath.node.Node;

public class StringNode<T>
extends Node<T> {
    private final String rawString;
    private final T string;

    public StringNode(Adapter<T> runtime, String rawString) {
        super(runtime);
        this.rawString = rawString;
        this.string = runtime.createString(rawString);
    }

    @Override
    public T search(T input) {
        return this.string;
    }

    @Override
    protected String internalToString() {
        return this.rawString;
    }

    @Override
    protected boolean internalEquals(Object o) {
        StringNode other = (StringNode)o;
        return this.rawString.equals(other.rawString);
    }

    @Override
    protected int internalHashCode() {
        return this.rawString.hashCode();
    }
}

