/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.function;

import io.burt.jmespath.Adapter;
import io.burt.jmespath.JmesPathType;
import io.burt.jmespath.function.ArgumentConstraint;
import io.burt.jmespath.function.ArgumentError;
import io.burt.jmespath.function.FunctionArgument;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class ArgumentConstraints {
    private static final String EXPRESSION_TYPE = "expression";

    public static ArgumentConstraint listOf(ArgumentConstraint ... constraints) {
        return new HeterogeneousListOf(constraints);
    }

    public static ArgumentConstraint listOf(int min, int max, ArgumentConstraint constraint) {
        return new HomogeneousListOf(min, max, constraint);
    }

    public static ArgumentConstraint listOf(int min, ArgumentConstraint constraint) {
        return new VariadicListOf(min, constraint);
    }

    public static ArgumentConstraint anyValue() {
        return new AnyValue();
    }

    public static ArgumentConstraint typeOf(JmesPathType type) {
        return new TypeOf(type);
    }

    public static ArgumentConstraint typeOf(JmesPathType ... types) {
        return new TypeOfEither(types);
    }

    public static ArgumentConstraint arrayOf(ArgumentConstraint constraint) {
        return new ArrayOf(constraint);
    }

    public static ArgumentConstraint expression() {
        return new Expression();
    }

    private ArgumentConstraints() {
    }

    private static class ArrayOf
    extends BaseArgumentConstraint {
        private ArgumentConstraint subConstraint;

        public ArrayOf(ArgumentConstraint subConstraint) {
            super(1, 1, String.format("array of %s", subConstraint.expectedType()));
            this.subConstraint = subConstraint;
        }

        @Override
        public <T> Iterator<ArgumentError> check(Adapter<T> runtime, Iterator<FunctionArgument<T>> arguments, boolean expectNoRemainingArguments) {
            if (arguments.hasNext()) {
                FunctionArgument<T> argument = arguments.next();
                if (argument.isExpression()) {
                    return this.singletonIterator(ArgumentError.createArgumentTypeError(this.expectedType(), ArgumentConstraints.EXPRESSION_TYPE));
                }
                T value = argument.value();
                JmesPathType type = runtime.typeOf(value);
                if (type == JmesPathType.ARRAY) {
                    Iterator<ArgumentError> error = this.checkElements(runtime, value);
                    if (error.hasNext()) {
                        return error;
                    }
                } else {
                    return this.singletonIterator(ArgumentError.createArgumentTypeError(this.expectedType(), type.toString()));
                }
                return this.checkNoRemainingArguments(arguments, expectNoRemainingArguments);
            }
            return this.singletonIterator(ArgumentError.createArityError());
        }

        private <T> Iterator<ArgumentError> checkElements(Adapter<T> runtime, T value) {
            List<T> elements = runtime.toList(value);
            if (!elements.isEmpty()) {
                ArrayList<FunctionArgument<T>> wrappedElements = new ArrayList<FunctionArgument<T>>(elements.size());
                LinkedHashSet<JmesPathType> types = new LinkedHashSet<JmesPathType>();
                for (T element : elements) {
                    wrappedElements.add(FunctionArgument.of(element));
                    types.add(runtime.typeOf(element));
                }
                if (types.size() > 1) {
                    return this.singletonIterator(this.createMixedTypesError(types));
                }
                Iterator wrappedElementsIterator = wrappedElements.iterator();
                while (wrappedElementsIterator.hasNext()) {
                    Iterator<ArgumentError> error = this.subConstraint.check(runtime, wrappedElementsIterator, false);
                    if (!error.hasNext()) continue;
                    ArgumentError e = error.next();
                    if (e instanceof ArgumentError.ArgumentTypeError) {
                        ArgumentError.ArgumentTypeError ee = (ArgumentError.ArgumentTypeError)e;
                        return this.singletonIterator(ArgumentError.createArgumentTypeError(this.expectedType(), String.format("array containing %s", ee.actualType())));
                    }
                    return this.singletonIterator(e);
                }
            }
            return this.emptyIterator();
        }

        private ArgumentError createMixedTypesError(Set<JmesPathType> types) {
            StringBuilder actualTypes = new StringBuilder("array containing ");
            Object[] typesArray = types.toArray();
            for (int i = 0; i < typesArray.length; ++i) {
                actualTypes.append(typesArray[i].toString());
                if (i < typesArray.length - 2) {
                    actualTypes.append(", ");
                    continue;
                }
                if (i >= typesArray.length - 1) continue;
                actualTypes.append(" and ");
            }
            return ArgumentError.createArgumentTypeError(this.expectedType(), actualTypes.toString());
        }
    }

    private static class Expression
    extends TypeCheck {
        public Expression() {
            super(ArgumentConstraints.EXPRESSION_TYPE);
        }

        @Override
        protected <T> Iterator<ArgumentError> checkType(Adapter<T> runtime, FunctionArgument<T> argument) {
            if (!argument.isExpression()) {
                return this.singletonIterator(ArgumentError.createArgumentTypeError(ArgumentConstraints.EXPRESSION_TYPE, runtime.typeOf(argument.value()).toString()));
            }
            return this.emptyIterator();
        }
    }

    private static class TypeOfEither
    extends TypeCheck {
        private final JmesPathType[] expectedTypes;

        public TypeOfEither(JmesPathType[] expectedTypes) {
            super(TypeOfEither.createExpectedTypeString(expectedTypes));
            this.expectedTypes = expectedTypes;
        }

        private static String createExpectedTypeString(JmesPathType[] expectedTypes) {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < expectedTypes.length; ++i) {
                buffer.append((Object)expectedTypes[i]);
                if (i < expectedTypes.length - 2) {
                    buffer.append(", ");
                    continue;
                }
                if (i >= expectedTypes.length - 1) continue;
                buffer.append(" or ");
            }
            return buffer.toString();
        }

        @Override
        protected <T> Iterator<ArgumentError> checkType(Adapter<T> runtime, FunctionArgument<T> argument) {
            if (argument.isExpression()) {
                return this.singletonIterator(ArgumentError.createArgumentTypeError(this.expectedType(), ArgumentConstraints.EXPRESSION_TYPE));
            }
            JmesPathType actualType = runtime.typeOf(argument.value());
            for (int i = 0; i < this.expectedTypes.length; ++i) {
                if (this.expectedTypes[i] != actualType) continue;
                return this.emptyIterator();
            }
            return this.singletonIterator(ArgumentError.createArgumentTypeError(this.expectedType(), actualType.toString()));
        }
    }

    private static class TypeOf
    extends TypeCheck {
        private final JmesPathType expectedType;

        public TypeOf(JmesPathType expectedType) {
            super(expectedType.toString());
            this.expectedType = expectedType;
        }

        @Override
        protected <T> Iterator<ArgumentError> checkType(Adapter<T> runtime, FunctionArgument<T> argument) {
            if (argument.isExpression()) {
                return this.singletonIterator(ArgumentError.createArgumentTypeError(this.expectedType.toString(), ArgumentConstraints.EXPRESSION_TYPE));
            }
            JmesPathType actualType = runtime.typeOf(argument.value());
            if (actualType != this.expectedType) {
                return this.singletonIterator(ArgumentError.createArgumentTypeError(this.expectedType.toString(), actualType.toString()));
            }
            return this.emptyIterator();
        }
    }

    private static class AnyValue
    extends TypeCheck {
        public AnyValue() {
            super("any value");
        }

        @Override
        protected <T> Iterator<ArgumentError> checkType(Adapter<T> runtime, FunctionArgument<T> argument) {
            if (argument.isExpression()) {
                return this.singletonIterator(ArgumentError.createArgumentTypeError("any value", ArgumentConstraints.EXPRESSION_TYPE));
            }
            return this.emptyIterator();
        }
    }

    private static abstract class TypeCheck
    extends BaseArgumentConstraint {
        public TypeCheck(String expectedType) {
            super(1, 1, expectedType);
        }

        @Override
        public <T> Iterator<ArgumentError> check(Adapter<T> runtime, Iterator<FunctionArgument<T>> arguments, boolean expectNoRemainingArguments) {
            if (arguments.hasNext()) {
                Iterator<ArgumentError> error = this.checkType(runtime, arguments.next());
                if (error.hasNext()) {
                    return error;
                }
                return this.checkNoRemainingArguments(arguments, expectNoRemainingArguments);
            }
            return this.singletonIterator(ArgumentError.createArityError());
        }

        protected abstract <T> Iterator<ArgumentError> checkType(Adapter<T> var1, FunctionArgument<T> var2);
    }

    private static class VariadicListOf
    extends BaseArgumentConstraint {
        private final ArgumentConstraint subConstraint;

        public VariadicListOf(int minArity, ArgumentConstraint subConstraint) {
            super(minArity, -1, subConstraint.expectedType());
            this.subConstraint = subConstraint;
        }

        @Override
        public <T> Iterator<ArgumentError> check(Adapter<T> runtime, Iterator<FunctionArgument<T>> arguments, boolean expectNoRemainingArguments) {
            int i = 0;
            while (arguments.hasNext()) {
                Iterator<ArgumentError> error = this.subConstraint.check(runtime, arguments, false);
                if (error.hasNext()) {
                    return error;
                }
                ++i;
            }
            if (i < this.minArity()) {
                return this.singletonIterator(ArgumentError.createArityError());
            }
            return this.emptyIterator();
        }

        @Override
        public boolean arityViolated(int n) {
            return n < this.minArity();
        }
    }

    private static class HeterogeneousListOf
    extends BaseArgumentConstraint {
        private final ArgumentConstraint[] subConstraints;

        public HeterogeneousListOf(ArgumentConstraint[] subConstraints) {
            super(HeterogeneousListOf.calculateMinArity(subConstraints), HeterogeneousListOf.calculateMaxArity(subConstraints), null);
            this.subConstraints = subConstraints;
        }

        private static int calculateMinArity(ArgumentConstraint[] subConstraints) {
            int min = 0;
            for (ArgumentConstraint constraint : subConstraints) {
                min += constraint.minArity();
            }
            return min;
        }

        private static int calculateMaxArity(ArgumentConstraint[] subConstraints) {
            int max = 0;
            for (ArgumentConstraint constraint : subConstraints) {
                max += constraint.maxArity();
            }
            return max;
        }

        @Override
        public <T> Iterator<ArgumentError> check(Adapter<T> runtime, Iterator<FunctionArgument<T>> arguments, boolean expectNoRemainingArguments) {
            for (int i = 0; i < this.subConstraints.length; ++i) {
                if (arguments.hasNext()) {
                    Iterator<ArgumentError> error = this.subConstraints[i].check(runtime, arguments, false);
                    if (!error.hasNext()) continue;
                    return error;
                }
                return this.singletonIterator(ArgumentError.createArityError());
            }
            return this.checkNoRemainingArguments(arguments, expectNoRemainingArguments);
        }
    }

    private static class HomogeneousListOf
    extends BaseArgumentConstraint {
        private final ArgumentConstraint subConstraint;

        public HomogeneousListOf(int minArity, int maxArity, ArgumentConstraint subConstraint) {
            super(minArity, maxArity, subConstraint.expectedType());
            this.subConstraint = subConstraint;
        }

        @Override
        public <T> Iterator<ArgumentError> check(Adapter<T> runtime, Iterator<FunctionArgument<T>> arguments, boolean expectNoRemainingArguments) {
            Iterator<ArgumentError> error;
            int i;
            for (i = 0; i < this.minArity(); ++i) {
                if (!arguments.hasNext()) {
                    return this.singletonIterator(ArgumentError.createArityError());
                }
                error = this.subConstraint.check(runtime, arguments, false);
                if (!error.hasNext()) continue;
                return error;
            }
            while (i < this.maxArity() && arguments.hasNext()) {
                error = this.subConstraint.check(runtime, arguments, false);
                if (error.hasNext()) {
                    return error;
                }
                ++i;
            }
            return this.checkNoRemainingArguments(arguments, expectNoRemainingArguments);
        }
    }

    private static abstract class BaseArgumentConstraint
    implements ArgumentConstraint {
        private final int minArity;
        private final int maxArity;
        private final String expectedTypeDescription;

        public BaseArgumentConstraint(int minArity, int maxArity, String expectedTypeDescription) {
            this.minArity = minArity;
            this.maxArity = maxArity;
            this.expectedTypeDescription = expectedTypeDescription;
        }

        protected <T> Iterator<ArgumentError> checkNoRemainingArguments(Iterator<FunctionArgument<T>> arguments, boolean expectNoRemainingArguments) {
            if (expectNoRemainingArguments && arguments.hasNext()) {
                return this.singletonIterator(ArgumentError.createArityError());
            }
            return this.emptyIterator();
        }

        @Override
        public int minArity() {
            return this.minArity;
        }

        @Override
        public int maxArity() {
            return this.maxArity;
        }

        @Override
        public boolean arityViolated(int n) {
            return n < this.minArity || this.maxArity < n;
        }

        @Override
        public String expectedType() {
            return this.expectedTypeDescription;
        }

        protected <U> Iterator<U> singletonIterator(U obj) {
            return Collections.singleton(obj).iterator();
        }

        protected <U> Iterator<U> emptyIterator() {
            return Collections.emptyIterator();
        }
    }
}

