/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto.dom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import jodd.csselly.CSSelly;
import jodd.csselly.Combinator;
import jodd.csselly.CssSelector;
import jodd.lagarto.dom.Node;
import jodd.lagarto.dom.NodeFilter;

public class NodeSelector {
    protected final Node rootNode;

    public NodeSelector(Node rootNode) {
        this.rootNode = rootNode;
    }

    public List<Node> select(String query) {
        List<List<CssSelector>> selectorsCollection = CSSelly.parse(query);
        return this.select(selectorsCollection);
    }

    public List<Node> select(Collection<List<CssSelector>> selectorsCollection) {
        ArrayList<Node> results = new ArrayList<Node>();
        for (List<CssSelector> selectors : selectorsCollection) {
            this.processSelectors(results, selectors);
        }
        return results;
    }

    protected void processSelectors(List<Node> results, List<CssSelector> selectors) {
        List<Node> selectedNodes = this.select(this.rootNode, selectors);
        for (Node selectedNode : selectedNodes) {
            if (results.contains(selectedNode)) continue;
            results.add(selectedNode);
        }
    }

    public Node selectFirst(String query) {
        List<Node> selectedNodes = this.select(query);
        if (selectedNodes.isEmpty()) {
            return null;
        }
        return selectedNodes.get(0);
    }

    public List<Node> select(NodeFilter nodeFilter) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        this.walk(this.rootNode, nodeFilter, nodes);
        return nodes;
    }

    public Node selectFirst(NodeFilter nodeFilter) {
        List<Node> selectedNodes = this.select(nodeFilter);
        if (selectedNodes.isEmpty()) {
            return null;
        }
        return selectedNodes.get(0);
    }

    protected void walk(Node rootNode, NodeFilter nodeFilter, List<Node> result) {
        int childCount = rootNode.getChildNodesCount();
        for (int i = 0; i < childCount; ++i) {
            Node node = rootNode.getChild(i);
            if (nodeFilter.accept(node)) {
                result.add(node);
            }
            this.walk(node, nodeFilter, result);
        }
    }

    protected List<Node> select(Node rootNode, List<CssSelector> selectors) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodes.add(rootNode);
        for (CssSelector cssSelector : selectors) {
            ArrayList<Node> selectedNodes = new ArrayList<Node>();
            for (Node node : nodes) {
                this.walk(node, cssSelector, selectedNodes);
            }
            ArrayList<Node> resultNodes = new ArrayList<Node>();
            int index = 0;
            for (Node node : selectedNodes) {
                boolean match = this.filter(selectedNodes, node, cssSelector, index);
                if (match) {
                    resultNodes.add(node);
                }
                ++index;
            }
            nodes = resultNodes;
        }
        return nodes;
    }

    protected void walkDescendantsIteratively(LinkedList<Node> nodes, CssSelector cssSelector, List<Node> result) {
        while (!nodes.isEmpty()) {
            Node node = nodes.removeFirst();
            this.selectAndAdd(node, cssSelector, result);
            int childCount = node.getChildNodesCount();
            for (int i = childCount - 1; i >= 0; --i) {
                nodes.addFirst(node.getChild(i));
            }
        }
    }

    protected void walk(Node rootNode, CssSelector cssSelector, List<Node> result) {
        CssSelector previousCssSelector = cssSelector.getPrevCssSelector();
        Combinator combinator = previousCssSelector != null ? previousCssSelector.getCombinator() : Combinator.DESCENDANT;
        switch (combinator) {
            case DESCENDANT: {
                LinkedList<Node> nodes = new LinkedList<Node>();
                int childCount = rootNode.getChildNodesCount();
                for (int i = 0; i < childCount; ++i) {
                    nodes.add(rootNode.getChild(i));
                }
                this.walkDescendantsIteratively(nodes, cssSelector, result);
                break;
            }
            case CHILD: {
                int childCount = rootNode.getChildNodesCount();
                for (int i = 0; i < childCount; ++i) {
                    Node node = rootNode.getChild(i);
                    this.selectAndAdd(node, cssSelector, result);
                }
                break;
            }
            case ADJACENT_SIBLING: {
                Node node = rootNode.getNextSiblingElement();
                if (node == null) break;
                this.selectAndAdd(node, cssSelector, result);
                break;
            }
            case GENERAL_SIBLING: {
                Node node = rootNode;
                while ((node = node.getNextSiblingElement()) != null) {
                    this.selectAndAdd(node, cssSelector, result);
                }
                break;
            }
        }
    }

    protected void selectAndAdd(Node node, CssSelector cssSelector, List<Node> result) {
        if (node.getNodeType() != Node.NodeType.ELEMENT) {
            return;
        }
        boolean matched = cssSelector.accept(node);
        if (matched) {
            if (result.contains(node)) {
                return;
            }
            result.add(node);
        }
    }

    protected boolean filter(List<Node> currentResults, Node node, CssSelector cssSelector, int index) {
        return cssSelector.accept(currentResults, node, index);
    }
}

