/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.proxy;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang3.CharUtils;
import org.apache.jmeter.protocol.http.config.MultipartUrlConfig;
import org.apache.jmeter.protocol.http.control.Header;
import org.apache.jmeter.protocol.http.control.HeaderManager;
import org.apache.jmeter.protocol.http.gui.HeaderPanel;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.protocol.http.util.ConversionUtils;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestHdr {
    private static final Logger log = LoggerFactory.getLogger(HttpRequestHdr.class);
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String PROXY_CONNECTION = "proxy-connection";
    private static final String CRLF = "<CRLF>";
    public static final String CONTENT_TYPE = "content-type";
    public static final String CONTENT_LENGTH = "content-length";
    private String method = "";
    private String paramHttps = "";
    private String url = "";
    private byte[] rawPostData;
    private final Map<String, Header> headers = new HashMap<String, Header>();
    private final String httpSamplerName;
    private HeaderManager headerManager;
    private String firstLine;
    private final String prefix;
    private final int httpSampleNameMode;
    private final String httpSampleNameFormat;
    private boolean detectGraphQLRequest;

    public HttpRequestHdr() {
        this("", "");
    }

    public HttpRequestHdr(String httpSamplerName) {
        this("", httpSamplerName);
    }

    public HttpRequestHdr(String prefix, String httpSamplerName) {
        this(prefix, httpSamplerName, 0, "{0}{1}");
    }

    public HttpRequestHdr(String prefix, String httpSamplerName, int httpSampleNameMode, String format) {
        this.prefix = prefix;
        this.httpSamplerName = httpSamplerName;
        this.firstLine = "";
        this.httpSampleNameMode = httpSampleNameMode;
        this.httpSampleNameFormat = format;
    }

    public boolean isDetectGraphQLRequest() {
        return this.detectGraphQLRequest;
    }

    public void setDetectGraphQLRequest(boolean detectGraphQLRequest) {
        this.detectGraphQLRequest = detectGraphQLRequest;
    }

    public byte[] parse(InputStream in) throws IOException {
        int x;
        boolean inHeaders = true;
        int readLength = 0;
        int dataLength = 0;
        boolean firstLine = true;
        ByteArrayOutputStream clientRequest = new ByteArrayOutputStream();
        ByteArrayOutputStream line = new ByteArrayOutputStream();
        while ((inHeaders || readLength < dataLength) && (x = in.read()) != -1) {
            line.write(x);
            clientRequest.write(x);
            if (firstLine && !CharUtils.isAscii((char)((char)x))) {
                throw new IllegalArgumentException("Only ASCII supported in headers (perhaps SSL was used?)");
            }
            if (inHeaders && (byte)x == 10) {
                if (line.size() < 3) {
                    inHeaders = false;
                    firstLine = false;
                }
                String reqLine = line.toString(StandardCharsets.UTF_8.name());
                if (firstLine) {
                    this.parseFirstLine(reqLine);
                    firstLine = false;
                } else {
                    int contentLen = this.parseLine(reqLine);
                    if (contentLen > 0) {
                        dataLength = contentLen;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("Client Request Line: '{}'", (Object)reqLine.replaceFirst("\r\n$", CRLF));
                }
                line.reset();
                continue;
            }
            if (inHeaders) continue;
            ++readLength;
        }
        this.rawPostData = line.toByteArray();
        if (log.isDebugEnabled()) {
            log.debug("rawPostData in default JRE encoding: {}, Request: '{}'", (Object)new String(this.rawPostData, Charset.defaultCharset()), (Object)clientRequest.toString(StandardCharsets.ISO_8859_1.name()).replaceAll("\r\n", CRLF));
        }
        return clientRequest.toByteArray();
    }

    private void parseFirstLine(String firstLine) {
        this.firstLine = firstLine;
        if (log.isDebugEnabled()) {
            log.debug("browser request: {}", (Object)firstLine.replaceFirst("\r\n$", CRLF));
        }
        StringTokenizer tz = new StringTokenizer(firstLine);
        this.method = HttpRequestHdr.getToken(tz).toUpperCase(Locale.ENGLISH);
        this.url = HttpRequestHdr.getToken(tz);
        String version = HttpRequestHdr.getToken(tz);
        if (log.isDebugEnabled()) {
            log.debug("parsed method: {}, url/host: {}, version: {}", new Object[]{this.method, this.url, version});
        }
        if (this.getMethod().startsWith("CONNECT")) {
            this.paramHttps = this.url;
            return;
        }
        if (this.url.startsWith("/")) {
            this.url = "https://" + this.paramHttps + this.url;
        }
        if ("Java".equals(this.httpSamplerName)) {
            log.debug("First Line url: {}", (Object)this.url);
            return;
        }
        try {
            URI testCleanUri = new URI(this.url);
            if (log.isDebugEnabled()) {
                log.debug("Successfully built URI from url:{} => {}", (Object)this.url, (Object)testCleanUri.toString());
            }
        }
        catch (URISyntaxException e) {
            log.warn("Url '{}' contains unsafe characters, will escape it, message:{}", (Object)this.url, (Object)e.getMessage());
            try {
                String escapedUrl = ConversionUtils.escapeIllegalURLCharacters(this.url);
                if (log.isDebugEnabled()) {
                    log.debug("Successfully escaped url:'{}' to:'{}'", (Object)this.url, (Object)escapedUrl);
                }
                this.url = escapedUrl;
            }
            catch (Exception e1) {
                log.error("Error escaping URL:'{}', message:{}", (Object)this.url, (Object)e1.getMessage());
            }
        }
        log.debug("First Line url: {}", (Object)this.url);
    }

    private int parseLine(String nextLine) {
        int colon = nextLine.indexOf(58);
        if (colon <= 0) {
            return 0;
        }
        String name = nextLine.substring(0, colon).trim();
        String value = nextLine.substring(colon + 1).trim();
        this.headers.put(name.toLowerCase(Locale.ENGLISH), new Header(name, value));
        if (name.equalsIgnoreCase(CONTENT_LENGTH)) {
            return Integer.parseInt(value);
        }
        return 0;
    }

    private HeaderManager createHeaderManager() {
        HeaderManager manager = new HeaderManager();
        for (Map.Entry<String, Header> entry : this.headers.entrySet()) {
            String key = entry.getKey();
            if (key.equals(PROXY_CONNECTION) || key.equals(CONTENT_LENGTH) || key.equalsIgnoreCase("Connection")) continue;
            manager.add(entry.getValue());
        }
        manager.setName(JMeterUtils.getResString((String)"header_manager_title"));
        manager.setProperty("TestElement.test_class", HeaderManager.class.getName());
        manager.setProperty("TestElement.gui_class", HeaderPanel.class.getName());
        return manager;
    }

    public HeaderManager getHeaderManager() {
        if (this.headerManager == null) {
            this.headerManager = this.createHeaderManager();
        }
        return this.headerManager;
    }

    public String getContentType() {
        Header contentTypeHeader = this.headers.get(CONTENT_TYPE);
        if (contentTypeHeader != null) {
            return contentTypeHeader.getValue();
        }
        return null;
    }

    private static boolean isMultipart(String contentType) {
        return contentType != null && contentType.startsWith("multipart/form-data");
    }

    public MultipartUrlConfig getMultipartConfig(String contentType) {
        if (HttpRequestHdr.isMultipart(contentType)) {
            String boundaryString = contentType.substring(contentType.toLowerCase(Locale.ENGLISH).indexOf("boundary=") + "boundary=".length());
            return new MultipartUrlConfig(boundaryString);
        }
        return null;
    }

    public String serverName() {
        String str = this.url;
        int i = str.indexOf("//");
        if (i > 0) {
            str = str.substring(i + 2);
        }
        if (0 < (i = str.indexOf(47))) {
            str = str.substring(0, i);
        }
        if (0 < (i = str.lastIndexOf(58))) {
            str = str.substring(0, i);
        }
        if (str.startsWith("[") && str.endsWith("]")) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    public int serverPort() {
        String str = this.url;
        int i = str.indexOf("//");
        if (i > 0) {
            str = str.substring(i + 2);
        }
        if (0 < (i = str.indexOf(47))) {
            str = str.substring(0, i);
        }
        if (0 < (i = str.lastIndexOf(58))) {
            return Integer.parseInt(str.substring(i + 1).trim());
        }
        return 0;
    }

    public String getPath() {
        String str = this.url;
        int i = str.indexOf("//");
        if (i > 0) {
            str = str.substring(i + 2);
        }
        if ((i = str.indexOf(47)) < 0) {
            return "";
        }
        return str.substring(i);
    }

    public String getUrl() {
        return this.url;
    }

    public String getMethod() {
        return this.method;
    }

    public String getFirstLine() {
        return this.firstLine;
    }

    private static String getToken(StringTokenizer tk) {
        if (tk.hasMoreTokens()) {
            return tk.nextToken();
        }
        return "";
    }

    public String getUrlWithoutQuery(URL url) {
        String fullUrl;
        String urlWithoutQuery = fullUrl = url.toString();
        String query = url.getQuery();
        if (query != null) {
            urlWithoutQuery = urlWithoutQuery.substring(0, urlWithoutQuery.length() - query.length() - 1);
        }
        return urlWithoutQuery;
    }

    public String getHttpSamplerName() {
        return this.httpSamplerName;
    }

    public byte[] getRawPostData() {
        return this.rawPostData;
    }

    public String getProtocol(HTTPSamplerBase sampler) {
        if (this.url.contains("//")) {
            String protocol = this.url.substring(0, this.url.indexOf(58));
            if (log.isDebugEnabled()) {
                log.debug("Proxy: setting protocol to : {}", (Object)protocol);
            }
            return protocol;
        }
        if (sampler.getPort() == 443) {
            if (log.isDebugEnabled()) {
                log.debug("Proxy: setting protocol to https");
            }
            return HTTPS;
        }
        if (log.isDebugEnabled()) {
            log.debug("Proxy setting default protocol to: http");
        }
        return HTTP;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public int getHttpSampleNameMode() {
        return this.httpSampleNameMode;
    }

    public String getHttpSampleNameFormat() {
        return this.httpSampleNameFormat;
    }
}

