/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml.bind.gml;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.sis.pending.geoapi.temporal.Period;
import org.apache.sis.util.internal.Strings;
import org.apache.sis.xml.bind.Context;
import org.apache.sis.xml.bind.gml.GMLAdapter;
import org.apache.sis.xml.bind.gml.TimePeriodBound;
import org.apache.sis.xml.util.LegacyNamespaces;

@XmlRootElement(name="TimePeriod")
@XmlType(propOrder={"begin", "end"})
public final class TimePeriod
extends GMLAdapter {
    @XmlElements(value={@XmlElement(type=TimePeriodBound.GML3.class, name="beginPosition"), @XmlElement(type=TimePeriodBound.GML2.class, name="begin")})
    public TimePeriodBound begin;
    @XmlElements(value={@XmlElement(type=TimePeriodBound.GML3.class, name="endPosition"), @XmlElement(type=TimePeriodBound.GML2.class, name="end")})
    public TimePeriodBound end;

    public TimePeriod() {
    }

    public TimePeriod(Period period) {
        super(period);
        if (period != null) {
            if (Context.isGMLVersion(Context.current(), LegacyNamespaces.VERSION_3_0)) {
                this.begin = new TimePeriodBound.GML3(period.getBeginning(), "before");
                this.end = new TimePeriodBound.GML3(period.getEnding(), "after");
            } else {
                this.begin = new TimePeriodBound.GML2(period.getBeginning());
                this.end = new TimePeriodBound.GML2(period.getEnding());
            }
        }
    }

    public String toString() {
        return Strings.range(this.getClass(), this.begin, this.end);
    }
}

