/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.IOUtils;

public final class FileDeleter {
    private final Map<String, RefCount> refCounts = new HashMap<String, RefCount>();
    private final Directory directory;
    private final BiConsumer<MsgType, String> messenger;
    private static final RefCount ZERO_REF = new RefCount("");

    public FileDeleter(Directory directory, BiConsumer<MsgType, String> messenger) {
        this.directory = directory;
        this.messenger = messenger;
    }

    public void incRef(Collection<String> fileNames) {
        for (String file : fileNames) {
            this.incRef(file);
        }
    }

    public void incRef(String fileName) {
        RefCount rc = this.getRefCountInternal(fileName);
        if (this.messenger != null) {
            this.messenger.accept(MsgType.REF, "IncRef \"" + fileName + "\": pre-incr count is " + rc.count);
        }
        rc.incRef();
    }

    public void decRef(Collection<String> fileNames) throws IOException {
        HashSet<String> toDelete = new HashSet<String>();
        Throwable firstThrowable = null;
        for (String fileName : fileNames) {
            try {
                if (!this.decRef(fileName)) continue;
                toDelete.add(fileName);
            }
            catch (Throwable t) {
                firstThrowable = IOUtils.useOrSuppress(firstThrowable, t);
            }
        }
        try {
            this.delete(toDelete);
        }
        catch (Throwable t) {
            firstThrowable = IOUtils.useOrSuppress(firstThrowable, t);
        }
        if (firstThrowable != null) {
            throw IOUtils.rethrowAlways(firstThrowable);
        }
    }

    private boolean decRef(String fileName) {
        RefCount rc = this.getRefCountInternal(fileName);
        if (this.messenger != null) {
            this.messenger.accept(MsgType.REF, "DecRef \"" + fileName + "\": pre-decr count is " + rc.count);
        }
        if (rc.decRef() == 0) {
            this.refCounts.remove(fileName);
            return true;
        }
        return false;
    }

    private RefCount getRefCountInternal(String fileName) {
        return this.refCounts.computeIfAbsent(fileName, RefCount::new);
    }

    public void initRefCount(String fileName) {
        this.refCounts.computeIfAbsent(fileName, RefCount::new);
    }

    public int getRefCount(String fileName) {
        return this.refCounts.getOrDefault((Object)fileName, (RefCount)FileDeleter.ZERO_REF).count;
    }

    public Set<String> getAllFiles() {
        return this.refCounts.keySet();
    }

    public boolean exists(String fileName) {
        return this.refCounts.containsKey(fileName) && this.refCounts.get((Object)fileName).count > 0;
    }

    public Set<String> getUnrefedFiles() {
        HashSet<String> unrefed = new HashSet<String>();
        for (Map.Entry<String, RefCount> entry : this.refCounts.entrySet()) {
            RefCount rc = entry.getValue();
            String fileName = entry.getKey();
            if (rc.count != 0) continue;
            this.messenger.accept(MsgType.FILE, "removing unreferenced file \"" + fileName + "\"");
            unrefed.add(fileName);
        }
        return unrefed;
    }

    public void deleteFilesIfNoRef(Collection<String> files) throws IOException {
        HashSet<String> toDelete = new HashSet<String>();
        for (String fileName : files) {
            if (this.exists(fileName)) continue;
            if (this.messenger != null) {
                this.messenger.accept(MsgType.FILE, "will delete new file \"" + fileName + "\"");
            }
            toDelete.add(fileName);
        }
        this.delete(toDelete);
    }

    public void forceDelete(String fileName) throws IOException {
        this.refCounts.remove(fileName);
        this.delete(fileName);
    }

    public void deleteFileIfNoRef(String fileName) throws IOException {
        if (!this.exists(fileName)) {
            if (this.messenger != null) {
                this.messenger.accept(MsgType.FILE, "will delete new file \"" + fileName + "\"");
            }
            this.delete(fileName);
        }
    }

    private void delete(Collection<String> toDelete) throws IOException {
        if (this.messenger != null) {
            this.messenger.accept(MsgType.FILE, "now delete " + toDelete.size() + " files: " + toDelete);
        }
        for (String fileName : toDelete) {
            assert (!this.exists(fileName));
            if (!fileName.startsWith("segments")) continue;
            this.delete(fileName);
        }
        for (String fileName : toDelete) {
            assert (!this.exists(fileName));
            if (fileName.startsWith("segments")) continue;
            this.delete(fileName);
        }
    }

    private void delete(String fileName) throws IOException {
        block2: {
            try {
                this.directory.deleteFile(fileName);
            }
            catch (FileNotFoundException | NoSuchFileException e2) {
                if (Constants.WINDOWS) break block2;
                throw e2;
            }
        }
    }

    public static final class RefCount {
        final String fileName;
        boolean initDone;
        int count;

        RefCount(String fileName) {
            this.fileName = fileName;
        }

        public int incRef() {
            if (!this.initDone) {
                this.initDone = true;
            } else assert (this.count > 0) : Thread.currentThread().getName() + ": RefCount is 0 pre-increment for file \"" + this.fileName + "\"";
            return ++this.count;
        }

        public int decRef() {
            assert (this.count > 0) : Thread.currentThread().getName() + ": RefCount is 0 pre-decrement for file \"" + this.fileName + "\"";
            return --this.count;
        }
    }

    public static enum MsgType {
        REF,
        FILE;

    }
}

