/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.assembler;

import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.assembler.exceptions.AssemblerException;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.dboe.base.file.Location;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.util.graph.GraphUtils;
import org.apache.jena.sys.JenaSystem;
import org.apache.jena.tdb2.DatabaseMgr;
import org.apache.jena.tdb2.assembler.DatasetAssemblerTDB2;
import org.apache.jena.tdb2.assembler.VocabTDB2;

public class TDB2GraphAssembler
extends AssemblerBase
implements Assembler {
    @Override
    public Model open(Assembler a, Resource root2, Mode mode) {
        Graph g = this.createGraph(a, root2, mode);
        return ModelFactory.createModelForGraph(g);
    }

    public Graph createGraph(Assembler a, Resource root2, Mode mode) {
        DatasetGraph dsg;
        String locationDir = GraphUtils.getAsFilename(root2, VocabTDB2.pLocation);
        Resource dataset = GraphUtils.getResourceValue(root2, VocabTDB2.pDataset);
        if (locationDir != null && dataset != null) {
            throw new AssemblerException(root2, "Both location and dataset given: exactly one required");
        }
        if (locationDir == null && dataset == null) {
            throw new AssemblerException(root2, "Must give location or refer to a dataset description");
        }
        String graphName = null;
        if (root2.hasProperty(VocabTDB2.pGraphName1)) {
            graphName = GraphUtils.getAsStringValue(root2, VocabTDB2.pGraphName1);
        }
        if (root2.hasProperty(VocabTDB2.pGraphName2)) {
            graphName = GraphUtils.getAsStringValue(root2, VocabTDB2.pGraphName2);
        }
        if (root2.hasProperty(VocabTDB2.pIndex)) {
            Log.warn(this, "Custom indexes not implemented yet - ignored");
        }
        if (locationDir != null) {
            Location location = Location.create(locationDir);
            dsg = DatabaseMgr.connectDatasetGraph(location);
        } else {
            dsg = DatasetAssemblerTDB2.make(a, dataset);
        }
        try {
            if (graphName != null) {
                return dsg.getGraph(NodeFactory.createURI(graphName));
            }
            return dsg.getDefaultGraph();
        }
        catch (RuntimeException ex) {
            ex.printStackTrace(System.err);
            throw ex;
        }
    }

    static {
        JenaSystem.init();
    }
}

