/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.binding;

import java.io.OutputStream;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Sink;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.riot.out.NodeFormatterTTL;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;

public class BindingOutputStream
implements Sink<Binding> {
    private final AWriter bw;
    private Binding lastBinding = null;
    private List<Var> vars = null;
    private PrefixMap pmap;
    private NodeFormatter nodeFormatter;
    private boolean needOutputPMap = true;
    private boolean needOutputVars = true;

    public BindingOutputStream(OutputStream out) {
        this(out, null, null);
    }

    public BindingOutputStream(OutputStream out, PrefixMap prefixMapping) {
        this(out, null, prefixMapping);
    }

    public BindingOutputStream(OutputStream out, List<Var> vars) {
        this(out, vars, null);
    }

    public BindingOutputStream(OutputStream out, List<Var> vars, PrefixMap prefixMapping) {
        this(IO.asBufferedUTF8(out), vars, prefixMapping);
    }

    private BindingOutputStream(Writer out, List<Var> variables, PrefixMap prefixMapping) {
        this.bw = IO.wrap(out);
        this.vars = variables;
        this.pmap = prefixMapping;
        this.nodeFormatter = new NodeFormatterTTL(null, this.pmap);
        this.needOutputVars = this.vars != null && this.vars.size() > 0;
    }

    public final void write(Binding binding) {
        this.send(binding);
    }

    @Override
    public void send(Binding binding) {
        if (this.needOutputPMap) {
            if (this.pmap != null) {
                for (Map.Entry entry : this.pmap.getMapping().entrySet()) {
                    this.bw.write("PREFIX ");
                    this.bw.write((String)entry.getKey());
                    this.bw.write(": <");
                    this.bw.write((String)entry.getValue());
                    this.bw.write("> .\n");
                }
            }
            this.needOutputPMap = false;
        }
        if (BindingOutputStream.needVars(this.vars, binding)) {
            if (this.vars == null) {
                this.vars = Iter.toList(binding.vars());
            } else {
                Iterator<Var> x = binding.vars();
                while (x.hasNext()) {
                    Var var = x.next();
                    if (this.vars.contains(var)) continue;
                    this.vars.add(var);
                }
            }
            this.needOutputVars = true;
        }
        if (this.needOutputVars) {
            if (binding.size() == 0 && this.vars.size() == 0) {
                this.bw.write(".\n");
                this.needOutputVars = false;
                return;
            }
            this.bw.write("VARS");
            for (Var var : this.vars) {
                this.bw.write(" ?");
                this.bw.write(var.getVarName());
            }
            this.bw.write(" .\n");
            this.needOutputVars = false;
        }
        for (Var var : this.vars) {
            Node n = binding.get(var);
            if (n == null) {
                this.bw.write("- ");
                continue;
            }
            this.nodeFormatter.format(this.bw, n);
            this.bw.write(" ");
        }
        this.bw.write(".\n");
    }

    private static boolean needVars(List<Var> vars, Binding binding) {
        if (vars == null) {
            return true;
        }
        List<Var> x = Iter.toList(binding.vars());
        return !x.equals(vars);
    }

    @Override
    public void flush() {
        IO.flush(this.bw);
    }

    @Override
    public void close() {
        IO.close(this.bw);
    }

    public List<Var> getVars() {
        return this.vars;
    }

    public void setVars(List<Var> vars) {
        this.vars = vars;
    }

    public PrefixMap getPrefixMap() {
        return this.pmap;
    }

    public void setPrefixMap(PrefixMap pmap) {
        this.pmap = pmap;
        this.needOutputPMap = true;
    }
}

