/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.observation;

import io.micrometer.common.lang.Nullable;
import io.micrometer.observation.Observation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public interface ObservationHandler<T extends Observation.Context> {
    default public void onStart(T context2) {
    }

    default public void onError(T context2) {
    }

    default public void onEvent(Observation.Event event, T context2) {
    }

    default public void onScopeOpened(T context2) {
    }

    default public void onScopeClosed(T context2) {
    }

    default public void onScopeReset(T context2) {
    }

    default public void onStop(T context2) {
    }

    public boolean supportsContext(Observation.Context var1);

    public static class AllMatchingCompositeObservationHandler
    implements CompositeObservationHandler {
        private final List<ObservationHandler<Observation.Context>> handlers;

        @SafeVarargs
        public AllMatchingCompositeObservationHandler(ObservationHandler<? extends Observation.Context> ... handlers) {
            this(Arrays.asList(handlers));
        }

        public AllMatchingCompositeObservationHandler(List<? extends ObservationHandler<? extends Observation.Context>> handlers) {
            ArrayList<ObservationHandler<Observation.Context>> castedHandlers = new ArrayList<ObservationHandler<Observation.Context>>(handlers.size());
            for (ObservationHandler<? extends Observation.Context> observationHandler : handlers) {
                castedHandlers.add(observationHandler);
            }
            this.handlers = castedHandlers;
        }

        @Override
        public List<ObservationHandler<Observation.Context>> getHandlers() {
            return this.handlers;
        }

        @Override
        public void onStart(Observation.Context context2) {
            for (ObservationHandler<Observation.Context> handler : this.handlers) {
                if (!handler.supportsContext(context2)) continue;
                handler.onStart(context2);
            }
        }

        @Override
        public void onError(Observation.Context context2) {
            for (ObservationHandler<Observation.Context> handler : this.handlers) {
                if (!handler.supportsContext(context2)) continue;
                handler.onError(context2);
            }
        }

        @Override
        public void onEvent(Observation.Event event, Observation.Context context2) {
            for (ObservationHandler<Observation.Context> handler : this.handlers) {
                if (!handler.supportsContext(context2)) continue;
                handler.onEvent(event, context2);
            }
        }

        @Override
        public void onScopeOpened(Observation.Context context2) {
            for (ObservationHandler<Observation.Context> handler : this.handlers) {
                if (!handler.supportsContext(context2)) continue;
                handler.onScopeOpened(context2);
            }
        }

        @Override
        public void onScopeClosed(Observation.Context context2) {
            for (ObservationHandler<Observation.Context> handler : this.handlers) {
                if (!handler.supportsContext(context2)) continue;
                handler.onScopeClosed(context2);
            }
        }

        @Override
        public void onScopeReset(Observation.Context context2) {
            for (ObservationHandler<Observation.Context> handler : this.handlers) {
                if (!handler.supportsContext(context2)) continue;
                handler.onScopeReset(context2);
            }
        }

        @Override
        public void onStop(Observation.Context context2) {
            for (ObservationHandler<Observation.Context> handler : this.handlers) {
                if (!handler.supportsContext(context2)) continue;
                handler.onStop(context2);
            }
        }

        @Override
        public boolean supportsContext(Observation.Context context2) {
            for (ObservationHandler<Observation.Context> handler : this.handlers) {
                if (!handler.supportsContext(context2)) continue;
                return true;
            }
            return false;
        }
    }

    public static class FirstMatchingCompositeObservationHandler
    implements CompositeObservationHandler {
        private final List<ObservationHandler<Observation.Context>> handlers;

        @SafeVarargs
        public FirstMatchingCompositeObservationHandler(ObservationHandler<? extends Observation.Context> ... handlers) {
            this(Arrays.asList(handlers));
        }

        public FirstMatchingCompositeObservationHandler(List<? extends ObservationHandler<? extends Observation.Context>> handlers) {
            ArrayList<ObservationHandler<Observation.Context>> castedHandlers = new ArrayList<ObservationHandler<Observation.Context>>(handlers.size());
            for (ObservationHandler<? extends Observation.Context> observationHandler : handlers) {
                castedHandlers.add(observationHandler);
            }
            this.handlers = castedHandlers;
        }

        @Override
        public List<ObservationHandler<Observation.Context>> getHandlers() {
            return this.handlers;
        }

        @Override
        public void onStart(Observation.Context context2) {
            ObservationHandler<Observation.Context> handler = this.getFirstApplicableHandler(context2);
            if (handler != null) {
                handler.onStart(context2);
            }
        }

        @Override
        public void onError(Observation.Context context2) {
            ObservationHandler<Observation.Context> handler = this.getFirstApplicableHandler(context2);
            if (handler != null) {
                handler.onError(context2);
            }
        }

        @Override
        public void onEvent(Observation.Event event, Observation.Context context2) {
            ObservationHandler<Observation.Context> handler = this.getFirstApplicableHandler(context2);
            if (handler != null) {
                handler.onEvent(event, context2);
            }
        }

        @Override
        public void onScopeOpened(Observation.Context context2) {
            ObservationHandler<Observation.Context> handler = this.getFirstApplicableHandler(context2);
            if (handler != null) {
                handler.onScopeOpened(context2);
            }
        }

        @Override
        public void onScopeClosed(Observation.Context context2) {
            ObservationHandler<Observation.Context> handler = this.getFirstApplicableHandler(context2);
            if (handler != null) {
                handler.onScopeClosed(context2);
            }
        }

        @Override
        public void onScopeReset(Observation.Context context2) {
            ObservationHandler<Observation.Context> handler = this.getFirstApplicableHandler(context2);
            if (handler != null) {
                handler.onScopeReset(context2);
            }
        }

        @Override
        public void onStop(Observation.Context context2) {
            ObservationHandler<Observation.Context> handler = this.getFirstApplicableHandler(context2);
            if (handler != null) {
                handler.onStop(context2);
            }
        }

        @Override
        public boolean supportsContext(Observation.Context context2) {
            ObservationHandler<Observation.Context> handler = this.getFirstApplicableHandler(context2);
            return handler != null;
        }

        @Nullable
        private ObservationHandler<Observation.Context> getFirstApplicableHandler(Observation.Context context2) {
            for (ObservationHandler<Observation.Context> handler : this.handlers) {
                if (!handler.supportsContext(context2)) continue;
                return handler;
            }
            return null;
        }
    }

    public static interface CompositeObservationHandler
    extends ObservationHandler<Observation.Context> {
        public List<ObservationHandler<Observation.Context>> getHandlers();
    }
}

