/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.base.file;

import org.apache.jena.dboe.base.file.BinaryDataFile;
import org.apache.jena.dboe.base.file.BinaryDataFileMem;
import org.apache.jena.dboe.base.file.BinaryDataFileRandomAccess;
import org.apache.jena.dboe.base.file.BinaryDataFileWriteBuffered;
import org.apache.jena.dboe.base.file.BufferChannel;
import org.apache.jena.dboe.base.file.BufferChannelFile;
import org.apache.jena.dboe.base.file.BufferChannelMem;
import org.apache.jena.dboe.base.file.FileSet;

public class FileFactory {
    public static BinaryDataFile createBinaryDataFile(FileSet fileset, String ext) {
        String x = fileset.filename(ext);
        if (fileset.isMem()) {
            return new BinaryDataFileMem();
        }
        BinaryDataFile bdf = new BinaryDataFileRandomAccess(x);
        bdf = new BinaryDataFileWriteBuffered(bdf);
        return bdf;
    }

    public static BinaryDataFile createBinaryDataFile() {
        return new BinaryDataFileMem();
    }

    public static BufferChannel createBufferChannel(FileSet fileset, String ext) {
        String x = fileset.filename(ext);
        if (fileset.isMem()) {
            return BufferChannelMem.create(x);
        }
        return BufferChannelFile.create(x);
    }

    public static BufferChannel createBufferChannelMem() {
        return FileFactory.createBufferChannel(FileSet.mem(), null);
    }
}

