/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfconnection;

import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdfconnection.RDFConnectionRemote;
import org.apache.jena.rdfconnection.RDFConnectionRemoteBuilder;
import org.apache.jena.rdflink.RDFConnectionAdapter;
import org.apache.jena.rdflink.RDFLink;
import org.apache.jena.rdflink.RDFLinkFuseki;

public interface RDFConnectionFuseki
extends RDFConnectionRemote {
    public static RDFConnection connect(String serviceURL) {
        return RDFConnectionFuseki.service(serviceURL).build();
    }

    public static RDFConnectionRemoteBuilder create() {
        return new RDFConnectionFusekiBuilder();
    }

    public static RDFConnectionRemoteBuilder newBuilder() {
        return new RDFConnectionFusekiBuilder();
    }

    public static RDFConnectionRemoteBuilder service(String destinationURL) {
        return RDFConnectionFuseki.newBuilder().destination(destinationURL);
    }

    public static class RDFConnectionFusekiBuilder
    extends RDFConnectionRemoteBuilder {
        protected RDFConnectionFusekiBuilder() {
            super(RDFLinkFuseki.newBuilder());
        }

        @Override
        protected RDFLink buildLink() {
            return this.builder.build();
        }

        @Override
        protected RDFConnection adaptLink(RDFLink rdfLink) {
            try {
                return new RDFConnectionFusekiImpl((RDFLinkFuseki)rdfLink);
            }
            catch (ClassCastException ex) {
                throw new InternalErrorException("Attempt to build a RDFConnectionFuseki from class " + rdfLink.getClass().getSimpleName());
            }
        }
    }

    public static class RDFConnectionFusekiImpl
    extends RDFConnectionAdapter
    implements RDFConnectionFuseki {
        private RDFConnectionFusekiImpl(RDFLinkFuseki linkFuseki) {
            super(linkFuseki);
        }
    }
}

