/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Enumerated;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.ldap.sdk.unboundidds.extensions.SubtreeAccessibilityState;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class SetSubtreeAccessibilityExtendedRequest
extends ExtendedRequest {
    @NotNull
    public static final String SET_SUBTREE_ACCESSIBILITY_REQUEST_OID = "1.3.6.1.4.1.30221.2.6.19";
    private static final byte TYPE_BYPASS_USER_DN = -128;
    private static final byte TYPE_ADDITIONAL_SUBTREE_BASE_DNS = -95;
    private static final long serialVersionUID = -6619215987488239440L;
    @NotNull
    private final List<String> subtreeBaseDNs;
    @Nullable
    private final String bypassUserDN;
    @NotNull
    private final SubtreeAccessibilityState accessibilityState;

    private SetSubtreeAccessibilityExtendedRequest(@NotNull Collection<String> subtreeBaseDNs, @NotNull SubtreeAccessibilityState accessibilityState, @Nullable String bypassUserDN, Control ... controls) {
        super(SET_SUBTREE_ACCESSIBILITY_REQUEST_OID, SetSubtreeAccessibilityExtendedRequest.encodeValue(subtreeBaseDNs, accessibilityState, bypassUserDN), controls);
        this.subtreeBaseDNs = Collections.unmodifiableList(new ArrayList<String>(subtreeBaseDNs));
        this.accessibilityState = accessibilityState;
        this.bypassUserDN = bypassUserDN;
    }

    @NotNull
    private static ASN1OctetString encodeValue(@NotNull Collection<String> subtreeBaseDNs, @NotNull SubtreeAccessibilityState accessibilityState, @Nullable String bypassUserDN) {
        Iterator<String> dnIterator = subtreeBaseDNs.iterator();
        String subtreeBaseDN = dnIterator.next();
        Validator.ensureNotNull(subtreeBaseDN);
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(4);
        elements.add(new ASN1OctetString(subtreeBaseDN));
        elements.add(new ASN1Enumerated(accessibilityState.intValue()));
        if (bypassUserDN != null) {
            elements.add(new ASN1OctetString(-128, bypassUserDN));
        }
        if (dnIterator.hasNext()) {
            ArrayList<ASN1OctetString> additionalDNElements = new ArrayList<ASN1OctetString>(subtreeBaseDNs.size() - 1);
            while (dnIterator.hasNext()) {
                String additionalDN = dnIterator.next();
                Validator.ensureNotNull(additionalDN);
                additionalDNElements.add(new ASN1OctetString(additionalDN));
            }
            elements.add(new ASN1Sequence(-95, additionalDNElements));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    public SetSubtreeAccessibilityExtendedRequest(@NotNull ExtendedRequest extendedRequest) throws LDAPException {
        super(extendedRequest);
        ASN1OctetString value = extendedRequest.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_SET_SUBTREE_ACCESSIBILITY_NO_VALUE.get());
        }
        try {
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(value.getValue()).elements();
            ArrayList<String> baseDNs = new ArrayList<String>(10);
            baseDNs.add(ASN1OctetString.decodeAsOctetString(elements[0]).stringValue());
            int accessibilityStateValue = ASN1Enumerated.decodeAsEnumerated(elements[1]).intValue();
            this.accessibilityState = SubtreeAccessibilityState.valueOf(accessibilityStateValue);
            if (this.accessibilityState == null) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_SET_SUBTREE_ACCESSIBILITY_INVALID_ACCESSIBILITY_STATE.get(accessibilityStateValue));
            }
            String bypassDN = null;
            block7: for (int i = 2; i < elements.length; ++i) {
                switch (elements[i].getType()) {
                    case -128: {
                        bypassDN = ASN1OctetString.decodeAsOctetString(elements[i]).stringValue();
                        continue block7;
                    }
                    case -95: {
                        for (ASN1Element e : ASN1Sequence.decodeAsSequence(elements[i]).elements()) {
                            baseDNs.add(ASN1OctetString.decodeAsOctetString(e).stringValue());
                        }
                        continue block7;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_SET_SUBTREE_ACCESSIBILITY_INVALID_ELEMENT_TYPE.get(StaticUtils.toHex(elements[i].getType())));
                    }
                }
            }
            this.bypassUserDN = bypassDN;
            this.subtreeBaseDNs = Collections.unmodifiableList(baseDNs);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_SET_SUBTREE_ACCESSIBILITY_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
        if (this.accessibilityState == SubtreeAccessibilityState.ACCESSIBLE && this.bypassUserDN != null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_SET_SUBTREE_ACCESSIBILITY_UNEXPECTED_BYPASS_DN.get(this.accessibilityState.getStateName()));
        }
        if (this.accessibilityState == SubtreeAccessibilityState.TO_BE_DELETED && this.bypassUserDN == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_SET_SUBTREE_ACCESSIBILITY_MISSING_BYPASS_DN.get(this.accessibilityState.getStateName()));
        }
    }

    @NotNull
    public static SetSubtreeAccessibilityExtendedRequest createSetAccessibleRequest(@NotNull String subtreeBaseDN, Control ... controls) {
        Validator.ensureNotNull(subtreeBaseDN);
        return new SetSubtreeAccessibilityExtendedRequest(Collections.singletonList(subtreeBaseDN), SubtreeAccessibilityState.ACCESSIBLE, null, controls);
    }

    @NotNull
    public static SetSubtreeAccessibilityExtendedRequest createSetAccessibleRequest(@NotNull Collection<String> subtreeBaseDNs, Control ... controls) {
        Validator.ensureNotNull(subtreeBaseDNs);
        Validator.ensureFalse(subtreeBaseDNs.isEmpty());
        return new SetSubtreeAccessibilityExtendedRequest(subtreeBaseDNs, SubtreeAccessibilityState.ACCESSIBLE, null, controls);
    }

    @NotNull
    public static SetSubtreeAccessibilityExtendedRequest createSetReadOnlyRequest(@NotNull String subtreeBaseDN, boolean allowBind, @Nullable String bypassUserDN, Control ... controls) {
        Validator.ensureNotNull(subtreeBaseDN);
        if (allowBind) {
            return new SetSubtreeAccessibilityExtendedRequest(Collections.singletonList(subtreeBaseDN), SubtreeAccessibilityState.READ_ONLY_BIND_ALLOWED, bypassUserDN, controls);
        }
        return new SetSubtreeAccessibilityExtendedRequest(Collections.singletonList(subtreeBaseDN), SubtreeAccessibilityState.READ_ONLY_BIND_DENIED, bypassUserDN, controls);
    }

    @NotNull
    public static SetSubtreeAccessibilityExtendedRequest createSetReadOnlyRequest(@NotNull Collection<String> subtreeBaseDNs, boolean allowBind, @Nullable String bypassUserDN, Control ... controls) {
        Validator.ensureNotNull(subtreeBaseDNs);
        Validator.ensureFalse(subtreeBaseDNs.isEmpty());
        if (allowBind) {
            return new SetSubtreeAccessibilityExtendedRequest(subtreeBaseDNs, SubtreeAccessibilityState.READ_ONLY_BIND_ALLOWED, bypassUserDN, controls);
        }
        return new SetSubtreeAccessibilityExtendedRequest(subtreeBaseDNs, SubtreeAccessibilityState.READ_ONLY_BIND_DENIED, bypassUserDN, controls);
    }

    @NotNull
    public static SetSubtreeAccessibilityExtendedRequest createSetHiddenRequest(@NotNull String subtreeBaseDN, @Nullable String bypassUserDN, Control ... controls) {
        Validator.ensureNotNull(subtreeBaseDN);
        return new SetSubtreeAccessibilityExtendedRequest(Collections.singletonList(subtreeBaseDN), SubtreeAccessibilityState.HIDDEN, bypassUserDN, controls);
    }

    @NotNull
    public static SetSubtreeAccessibilityExtendedRequest createSetHiddenRequest(@NotNull Collection<String> subtreeBaseDNs, @Nullable String bypassUserDN, Control ... controls) {
        Validator.ensureNotNull(subtreeBaseDNs);
        Validator.ensureFalse(subtreeBaseDNs.isEmpty());
        return new SetSubtreeAccessibilityExtendedRequest(subtreeBaseDNs, SubtreeAccessibilityState.HIDDEN, bypassUserDN, controls);
    }

    @NotNull
    public static SetSubtreeAccessibilityExtendedRequest createSetToBeDeletedRequest(@NotNull String subtreeBaseDN, @NotNull String bypassUserDN, Control ... controls) {
        Validator.ensureNotNull(subtreeBaseDN);
        Validator.ensureNotNull(bypassUserDN);
        return new SetSubtreeAccessibilityExtendedRequest(Collections.singletonList(subtreeBaseDN), SubtreeAccessibilityState.TO_BE_DELETED, bypassUserDN, controls);
    }

    @NotNull
    public static SetSubtreeAccessibilityExtendedRequest createSetToBeDeletedRequest(@NotNull Collection<String> subtreeBaseDNs, @NotNull String bypassUserDN, Control ... controls) {
        Validator.ensureNotNull(subtreeBaseDNs);
        Validator.ensureFalse(subtreeBaseDNs.isEmpty());
        Validator.ensureNotNull(bypassUserDN);
        return new SetSubtreeAccessibilityExtendedRequest(subtreeBaseDNs, SubtreeAccessibilityState.TO_BE_DELETED, bypassUserDN, controls);
    }

    @NotNull
    public String getSubtreeBaseDN() {
        return this.subtreeBaseDNs.get(0);
    }

    @NotNull
    public List<String> getSubtreeBaseDNs() {
        return this.subtreeBaseDNs;
    }

    @NotNull
    public SubtreeAccessibilityState getAccessibilityState() {
        return this.accessibilityState;
    }

    @Nullable
    public String getBypassUserDN() {
        return this.bypassUserDN;
    }

    @Override
    @NotNull
    public SetSubtreeAccessibilityExtendedRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    @NotNull
    public SetSubtreeAccessibilityExtendedRequest duplicate(@Nullable Control[] controls) {
        SetSubtreeAccessibilityExtendedRequest r = new SetSubtreeAccessibilityExtendedRequest(this.subtreeBaseDNs, this.accessibilityState, this.bypassUserDN, controls);
        r.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        r.setIntermediateResponseListener(this.getIntermediateResponseListener());
        r.setReferralDepth(this.getReferralDepth());
        r.setReferralConnector(this.getReferralConnectorInternal());
        return r;
    }

    @Override
    @NotNull
    public String getExtendedRequestName() {
        return ExtOpMessages.INFO_EXTENDED_REQUEST_NAME_SET_SUBTREE_ACCESSIBILITY.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        Control[] controls;
        buffer.append("SetSubtreeAccessibilityExtendedRequest(baseDNs={");
        Iterator<String> dnIterator = this.subtreeBaseDNs.iterator();
        while (dnIterator.hasNext()) {
            buffer.append('\"');
            buffer.append(dnIterator.next());
            buffer.append('\"');
            if (!dnIterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("}, accessibilityType=\"");
        buffer.append(this.accessibilityState.getStateName());
        buffer.append('\"');
        if (this.bypassUserDN != null) {
            buffer.append(", bypassUserDN=\"");
            buffer.append(this.bypassUserDN);
            buffer.append('\"');
        }
        if ((controls = this.getControls()).length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

