/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailet.base;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.Strings;
import jakarta.mail.MessagingException;
import java.util.Optional;
import org.apache.mailet.MailetConfig;

public class MailetUtil {
    public static Optional<Boolean> getInitParameter(MailetConfig config, String name) {
        String value = config.getInitParameter(name);
        if ("true".equalsIgnoreCase(value)) {
            return Optional.of(true);
        }
        if ("false".equalsIgnoreCase(value)) {
            return Optional.of(false);
        }
        return Optional.empty();
    }

    public static int getInitParameterAsStrictlyPositiveInteger(String condition, int defaultValue) throws MessagingException {
        return MailetUtil.getInitParameterAsStrictlyPositiveInteger(condition, Optional.of(defaultValue));
    }

    public static int getInitParameterAsStrictlyPositiveInteger(String condition) throws MessagingException {
        return MailetUtil.getInitParameterAsStrictlyPositiveInteger(condition, Optional.empty());
    }

    private static int getInitParameterAsStrictlyPositiveInteger(String condition, Optional<Integer> defaultValue) throws MessagingException {
        int valueAsInt = MailetUtil.getInitParameterAsInteger(condition, defaultValue);
        if (valueAsInt < 1) {
            throw new MessagingException("Expecting condition to be a strictly positive integer. Got " + valueAsInt);
        }
        return valueAsInt;
    }

    public static int getInitParameterAsInteger(String condition, Optional<Integer> defaultValue) throws MessagingException {
        if (Strings.isNullOrEmpty((String)condition) && defaultValue.isEmpty()) {
            throw new MessagingException("Condition is required. It should be a strictly positive integer");
        }
        return (Integer)Optional.ofNullable(condition).map(Throwing.function(MailetUtil::tryParseInteger).sneakyThrow()).or(() -> defaultValue).get();
    }

    private static int tryParseInteger(String value) throws MessagingException {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new MessagingException("Expecting condition to be a strictly positive integer. Got " + value);
        }
    }
}

