/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.message.backend;

import io.netty.buffer.ByteBuf;
import io.r2dbc.postgresql.message.backend.BackendMessage;
import io.r2dbc.postgresql.util.Assert;
import java.util.Objects;

public final class ReadyForQuery
implements BackendMessage {
    private final TransactionStatus transactionStatus;

    public ReadyForQuery(TransactionStatus transactionStatus) {
        this.transactionStatus = Assert.requireNonNull(transactionStatus, "transactionStatus must not be null");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadyForQuery that = (ReadyForQuery)o;
        return this.transactionStatus == that.transactionStatus;
    }

    public TransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.transactionStatus});
    }

    public String toString() {
        return "ReadyForQuery{transactionStatus=" + (Object)((Object)this.transactionStatus) + '}';
    }

    static ReadyForQuery decode(ByteBuf in) {
        Assert.requireNonNull(in, "in must not be null");
        return new ReadyForQuery(TransactionStatus.valueOf(in.readByte()));
    }

    public static enum TransactionStatus {
        ERROR('E'),
        IDLE('I'),
        TRANSACTION('T');

        private final char discriminator;

        private TransactionStatus(char discriminator) {
            this.discriminator = discriminator;
        }

        static TransactionStatus valueOf(byte b) {
            switch (b) {
                case 69: {
                    return ERROR;
                }
                case 73: {
                    return IDLE;
                }
                case 84: {
                    return TRANSACTION;
                }
            }
            throw new IllegalArgumentException(String.format("%c is not a valid transaction status", b));
        }
    }
}

