/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.postgres.projections;

import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import org.apache.james.backends.postgres.utils.PostgresExecutor;
import org.apache.james.jmap.api.model.Preview;
import org.apache.james.jmap.api.projections.MessageFastViewPrecomputedProperties;
import org.apache.james.jmap.api.projections.MessageFastViewProjection;
import org.apache.james.jmap.postgres.projections.PostgresMessageFastViewProjectionDataDefinition;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.postgres.PostgresMessageId;
import org.apache.james.metrics.api.Metric;
import org.apache.james.metrics.api.MetricFactory;
import org.jooq.Field;
import org.jooq.Record;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class PostgresMessageFastViewProjection
implements MessageFastViewProjection {
    public static final Logger LOGGER = LoggerFactory.getLogger(PostgresMessageFastViewProjection.class);
    private final PostgresExecutor postgresExecutor;
    private final Metric metricRetrieveHitCount;
    private final Metric metricRetrieveMissCount;

    @Inject
    public PostgresMessageFastViewProjection(PostgresExecutor postgresExecutor, MetricFactory metricFactory) {
        this.postgresExecutor = postgresExecutor;
        this.metricRetrieveHitCount = metricFactory.generate("MessageFastViewProjection:retrieveHitCount");
        this.metricRetrieveMissCount = metricFactory.generate("MessageFastViewProjection:retrieveMissCount");
    }

    public Publisher<Void> store(MessageId messageId, MessageFastViewPrecomputedProperties precomputedProperties) {
        return this.postgresExecutor.executeVoid(dslContext -> Mono.from((Publisher)dslContext.insertInto(PostgresMessageFastViewProjectionDataDefinition.MessageFastViewProjectionTable.TABLE_NAME).set(PostgresMessageFastViewProjectionDataDefinition.MessageFastViewProjectionTable.MESSAGE_ID, (Object)((PostgresMessageId)messageId).asUuid()).set(PostgresMessageFastViewProjectionDataDefinition.MessageFastViewProjectionTable.PREVIEW, (Object)precomputedProperties.getPreview().getValue()).set(PostgresMessageFastViewProjectionDataDefinition.MessageFastViewProjectionTable.HAS_ATTACHMENT, (Object)precomputedProperties.hasAttachment()).onConflict(new Field[]{PostgresMessageFastViewProjectionDataDefinition.MessageFastViewProjectionTable.MESSAGE_ID}).doUpdate().set(PostgresMessageFastViewProjectionDataDefinition.MessageFastViewProjectionTable.PREVIEW, (Object)precomputedProperties.getPreview().getValue()).set(PostgresMessageFastViewProjectionDataDefinition.MessageFastViewProjectionTable.HAS_ATTACHMENT, (Object)precomputedProperties.hasAttachment())));
    }

    public Publisher<MessageFastViewPrecomputedProperties> retrieve(MessageId messageId) {
        Preconditions.checkNotNull((Object)messageId);
        return this.postgresExecutor.executeRow(dslContext -> Mono.from((Publisher)dslContext.select(PostgresMessageFastViewProjectionDataDefinition.MessageFastViewProjectionTable.PREVIEW, PostgresMessageFastViewProjectionDataDefinition.MessageFastViewProjectionTable.HAS_ATTACHMENT).from(PostgresMessageFastViewProjectionDataDefinition.MessageFastViewProjectionTable.TABLE_NAME).where(PostgresMessageFastViewProjectionDataDefinition.MessageFastViewProjectionTable.MESSAGE_ID.eq((Object)((PostgresMessageId)messageId).asUuid())))).doOnNext(preview -> this.metricRetrieveHitCount.increment()).switchIfEmpty(Mono.fromRunnable(() -> ((Metric)this.metricRetrieveMissCount).increment())).map(this::toMessageFastViewPrecomputedProperties).onErrorResume(e -> {
            LOGGER.error("Error while retrieving MessageFastView projection item for {}", (Object)messageId, e);
            return Mono.empty();
        });
    }

    private MessageFastViewPrecomputedProperties toMessageFastViewPrecomputedProperties(Record record) {
        return MessageFastViewPrecomputedProperties.builder().preview(Preview.from((String)((String)record.get(PostgresMessageFastViewProjectionDataDefinition.MessageFastViewProjectionTable.PREVIEW)))).hasAttachment(((Boolean)record.get(PostgresMessageFastViewProjectionDataDefinition.MessageFastViewProjectionTable.HAS_ATTACHMENT)).booleanValue()).build();
    }

    public Publisher<Void> delete(MessageId messageId) {
        return this.postgresExecutor.executeVoid(dslContext -> Mono.from((Publisher)dslContext.deleteFrom(PostgresMessageFastViewProjectionDataDefinition.MessageFastViewProjectionTable.TABLE_NAME).where(PostgresMessageFastViewProjectionDataDefinition.MessageFastViewProjectionTable.MESSAGE_ID.eq((Object)((PostgresMessageId)messageId).asUuid()))));
    }

    public Publisher<Void> clear() {
        return this.postgresExecutor.executeVoid(dslContext -> Mono.from((Publisher)dslContext.truncate(PostgresMessageFastViewProjectionDataDefinition.MessageFastViewProjectionTable.TABLE_NAME)));
    }
}

