/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.quota.task;

import jakarta.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaComponent;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.model.CurrentQuotas;
import org.apache.james.mailbox.model.QuotaOperation;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.CurrentQuotaManager;
import org.apache.james.mailbox.quota.UserQuotaRootResolver;
import org.apache.james.mailbox.quota.task.RecomputeSingleComponentCurrentQuotasService;
import org.apache.james.mailbox.store.quota.CurrentQuotaCalculator;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class RecomputeMailboxCurrentQuotasService
implements RecomputeSingleComponentCurrentQuotasService {
    private final CurrentQuotaManager storeCurrentQuotaManager;
    private final CurrentQuotaCalculator currentQuotaCalculator;
    private final UserQuotaRootResolver userQuotaRootResolver;
    private final SessionProvider sessionProvider;
    private final MailboxManager mailboxManager;

    @Inject
    public RecomputeMailboxCurrentQuotasService(CurrentQuotaManager storeCurrentQuotaManager, CurrentQuotaCalculator currentQuotaCalculator, UserQuotaRootResolver userQuotaRootResolver, SessionProvider sessionProvider, MailboxManager mailboxManager) {
        this.storeCurrentQuotaManager = storeCurrentQuotaManager;
        this.currentQuotaCalculator = currentQuotaCalculator;
        this.userQuotaRootResolver = userQuotaRootResolver;
        this.sessionProvider = sessionProvider;
        this.mailboxManager = mailboxManager;
    }

    @Override
    public QuotaComponent getQuotaComponent() {
        return QuotaComponent.MAILBOX;
    }

    @Override
    public Mono<Void> recomputeCurrentQuotas(Username username) {
        MailboxSession session = this.sessionProvider.createSystemSession(username);
        QuotaRoot quotaRoot = this.userQuotaRootResolver.forUser(username);
        return this.currentQuotaCalculator.recalculateCurrentQuotas(quotaRoot, session).map(recalculatedQuotas -> QuotaOperation.from((QuotaRoot)quotaRoot, (CurrentQuotas)recalculatedQuotas)).flatMap(quotaOperation -> Mono.from((Publisher)this.storeCurrentQuotaManager.setCurrentQuotas(quotaOperation))).doFinally(any -> this.mailboxManager.endProcessingRequest(session));
    }
}

