/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.objectstorage.aws;

import java.time.Duration;
import org.apache.james.metrics.api.GaugeRegistry;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.TimeMetric;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.http.HttpMetric;
import software.amazon.awssdk.metrics.MetricCollection;
import software.amazon.awssdk.metrics.MetricPublisher;

public class JamesS3MetricPublisher
implements MetricPublisher {
    public static final String DEFAULT_S3_METRICS_PREFIX = "s3";
    private final GaugeRegistry.SettableGauge<Integer> availableConcurrency;
    private final GaugeRegistry.SettableGauge<Integer> leasedConcurrency;
    private final GaugeRegistry.SettableGauge<Integer> pendingConcurrencyAcquires;
    private final TimeMetric concurrencyAcquireDuration;
    private final TimeMetric apiCallDuration;

    public JamesS3MetricPublisher(MetricFactory metricFactory, GaugeRegistry gaugeRegistry, String metricPrefix) {
        this.availableConcurrency = gaugeRegistry.settableGauge(metricPrefix + "_httpClient_availableConcurrency");
        this.leasedConcurrency = gaugeRegistry.settableGauge(metricPrefix + "_httpClient_leasedConcurrency");
        this.pendingConcurrencyAcquires = gaugeRegistry.settableGauge(metricPrefix + "_httpClient_pendingConcurrencyAcquires");
        this.concurrencyAcquireDuration = metricFactory.timer(metricPrefix + "_httpClient_concurrencyAcquireDuration");
        this.apiCallDuration = metricFactory.timer(metricPrefix + "_apiCall_apiCallDuration");
    }

    public void publish(MetricCollection s3ClientMetrics) {
        this.extractS3ClientMetrics(s3ClientMetrics);
    }

    private void extractS3ClientMetrics(MetricCollection s3ClientMetrics) {
        s3ClientMetrics.stream().forEach(metricRecord -> {
            if (metricRecord.metric().equals((Object)HttpMetric.AVAILABLE_CONCURRENCY)) {
                this.availableConcurrency.setValue((Object)((Integer)metricRecord.value()));
            }
            if (metricRecord.metric().equals((Object)HttpMetric.LEASED_CONCURRENCY)) {
                this.leasedConcurrency.setValue((Object)((Integer)metricRecord.value()));
            }
            if (metricRecord.metric().equals((Object)HttpMetric.PENDING_CONCURRENCY_ACQUIRES)) {
                this.pendingConcurrencyAcquires.setValue((Object)((Integer)metricRecord.value()));
            }
            if (metricRecord.metric().equals((Object)HttpMetric.CONCURRENCY_ACQUIRE_DURATION)) {
                this.concurrencyAcquireDuration.record((Duration)metricRecord.value());
            }
            if (metricRecord.metric().equals((Object)CoreMetric.API_CALL_DURATION)) {
                this.apiCallDuration.record((Duration)metricRecord.value());
            }
        });
        s3ClientMetrics.children().forEach(this::extractS3ClientMetrics);
    }

    public void close() {
    }
}

