/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.codec;

import com.github.f4b6a3.uuid.codec.UuidCodec;
import com.github.f4b6a3.uuid.codec.base.Base16Codec;
import com.github.f4b6a3.uuid.exception.InvalidUuidException;
import com.github.f4b6a3.uuid.util.UuidValidator;
import com.github.f4b6a3.uuid.util.immutable.CharArray;
import com.github.f4b6a3.uuid.util.internal.JavaVersionUtil;
import java.util.UUID;

public class StandardStringCodec
implements UuidCodec<String> {
    public static final StandardStringCodec INSTANCE = new StandardStringCodec();
    private static final int DASH_POSITION_1 = 8;
    private static final int DASH_POSITION_2 = 13;
    private static final int DASH_POSITION_3 = 18;
    private static final int DASH_POSITION_4 = 23;
    private static final int LENGTH_WITH_DASH = 36;
    private static final int LENGTH_WITHOUT_DASH = 32;
    private static final int LENGTH_WITH_URN_PREFIX = 45;
    private static final int LENGTH_WITH_CURLY_BRACES = 38;
    private static final byte[] MAP = Base16Codec.INSTANCE.getBase().getMap().array();
    private static final CharArray ALPHABET = Base16Codec.INSTANCE.getBase().getAlphabet();
    private static final String URN_PREFIX = "urn:uuid:";
    private static final boolean JAVA_VERSION_GREATER_THAN_8 = JavaVersionUtil.getJavaVersion() > 8;

    @Override
    public String encode(UUID uuid) {
        UuidValidator.validate(uuid);
        if (JAVA_VERSION_GREATER_THAN_8) {
            return uuid.toString();
        }
        char[] chars = new char[36];
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        chars[0] = ALPHABET.get((int)(msb >>> 60 & 0xFL));
        chars[1] = ALPHABET.get((int)(msb >>> 56 & 0xFL));
        chars[2] = ALPHABET.get((int)(msb >>> 52 & 0xFL));
        chars[3] = ALPHABET.get((int)(msb >>> 48 & 0xFL));
        chars[4] = ALPHABET.get((int)(msb >>> 44 & 0xFL));
        chars[5] = ALPHABET.get((int)(msb >>> 40 & 0xFL));
        chars[6] = ALPHABET.get((int)(msb >>> 36 & 0xFL));
        chars[7] = ALPHABET.get((int)(msb >>> 32 & 0xFL));
        chars[8] = 45;
        chars[9] = ALPHABET.get((int)(msb >>> 28 & 0xFL));
        chars[10] = ALPHABET.get((int)(msb >>> 24 & 0xFL));
        chars[11] = ALPHABET.get((int)(msb >>> 20 & 0xFL));
        chars[12] = ALPHABET.get((int)(msb >>> 16 & 0xFL));
        chars[13] = 45;
        chars[14] = ALPHABET.get((int)(msb >>> 12 & 0xFL));
        chars[15] = ALPHABET.get((int)(msb >>> 8 & 0xFL));
        chars[16] = ALPHABET.get((int)(msb >>> 4 & 0xFL));
        chars[17] = ALPHABET.get((int)(msb & 0xFL));
        chars[18] = 45;
        chars[19] = ALPHABET.get((int)(lsb >>> 60 & 0xFL));
        chars[20] = ALPHABET.get((int)(lsb >>> 56 & 0xFL));
        chars[21] = ALPHABET.get((int)(lsb >>> 52 & 0xFL));
        chars[22] = ALPHABET.get((int)(lsb >>> 48 & 0xFL));
        chars[23] = 45;
        chars[24] = ALPHABET.get((int)(lsb >>> 44 & 0xFL));
        chars[25] = ALPHABET.get((int)(lsb >>> 40 & 0xFL));
        chars[26] = ALPHABET.get((int)(lsb >>> 36 & 0xFL));
        chars[27] = ALPHABET.get((int)(lsb >>> 32 & 0xFL));
        chars[28] = ALPHABET.get((int)(lsb >>> 28 & 0xFL));
        chars[29] = ALPHABET.get((int)(lsb >>> 24 & 0xFL));
        chars[30] = ALPHABET.get((int)(lsb >>> 20 & 0xFL));
        chars[31] = ALPHABET.get((int)(lsb >>> 16 & 0xFL));
        chars[32] = ALPHABET.get((int)(lsb >>> 12 & 0xFL));
        chars[33] = ALPHABET.get((int)(lsb >>> 8 & 0xFL));
        chars[34] = ALPHABET.get((int)(lsb >>> 4 & 0xFL));
        chars[35] = ALPHABET.get((int)(lsb & 0xFL));
        return new String(chars);
    }

    @Override
    public UUID decode(String string) {
        if (string == null) {
            throw InvalidUuidException.newInstance(null);
        }
        String modified = StandardStringCodec.modify(string);
        if (modified.length() == 36) {
            StandardStringCodec.validate(modified);
            return this.parse(modified);
        }
        if (modified.length() == 32) {
            return Base16Codec.INSTANCE.decode(modified);
        }
        throw InvalidUuidException.newInstance(modified);
    }

    private UUID parse(String string) {
        int i;
        long msb = 0L;
        long lsb = 0L;
        for (i = 0; i < 8; ++i) {
            msb = msb << 4 | this.get(string, i);
        }
        for (i = 9; i < 13; ++i) {
            msb = msb << 4 | this.get(string, i);
        }
        for (i = 14; i < 18; ++i) {
            msb = msb << 4 | this.get(string, i);
        }
        for (i = 19; i < 23; ++i) {
            lsb = lsb << 4 | this.get(string, i);
        }
        for (i = 24; i < 36; ++i) {
            lsb = lsb << 4 | this.get(string, i);
        }
        return new UUID(msb, lsb);
    }

    protected static String modify(String string) {
        if (string.length() == 45 && string.startsWith(URN_PREFIX)) {
            return string.substring(URN_PREFIX.length());
        }
        if (string.length() == 38 && string.startsWith("{") && string.endsWith("}")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    private static void validate(String string) {
        if (string.charAt(8) != '-' || string.charAt(13) != '-' || string.charAt(18) != '-' || string.charAt(23) != '-') {
            throw InvalidUuidException.newInstance(string);
        }
    }

    private long get(String string, int i) {
        char chr = string.charAt(i);
        if (chr > '\u00ff') {
            throw InvalidUuidException.newInstance(string);
        }
        byte value = MAP[chr];
        if (value < 0) {
            throw InvalidUuidException.newInstance(string);
        }
        return (long)value & 0xFFL;
    }
}

