/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.mail;

import cats.Applicative;
import cats.UnorderedFoldable$;
import cats.implicits$;
import eu.timepit.refined.api.RefType$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.boolean;
import eu.timepit.refined.collection;
import eu.timepit.refined.package$;
import jakarta.mail.Flags;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.james.jmap.core.Id$;
import org.apache.james.jmap.core.Properties;
import org.apache.james.jmap.core.Properties$;
import org.apache.james.jmap.mail.EmailBodyPart$;
import org.apache.james.jmap.mail.EmailView;
import org.apache.james.jmap.mail.Keywords;
import org.apache.james.jmap.mail.KeywordsFactory$;
import org.apache.james.jmap.mail.SpecificHeaderRequest$;
import org.apache.james.jmap.mail.UnparsedEmailId;
import org.apache.james.jmap.mime4j.AvoidBinaryBodyBufferingBodyFactory;
import org.apache.james.jmap.mime4j.JamesBodyDescriptorBuilder;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.FieldParser;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.dom.field.ParsedField;
import org.apache.james.mime4j.field.LenientFieldParser;
import org.apache.james.mime4j.message.BodyFactory;
import org.apache.james.mime4j.message.DefaultMessageBuilder;
import org.apache.james.mime4j.stream.BodyDescriptorBuilder;
import org.apache.james.mime4j.stream.MimeConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.SetOps;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class Email$ {
    public static final Email$ MODULE$ = new Email$();
    private static final Logger logger = LoggerFactory.getLogger(EmailView.class);
    private static final Charset defaultCharset = (Charset)Option$.MODULE$.apply((Object)System.getenv("james.jmap.default.charset")).map((Function1 & Serializable)value -> Charset.forName(value)).getOrElse((Function0 & Serializable)() -> StandardCharsets.US_ASCII);
    private static final Properties defaultProperties = Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"id")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"blobId")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"threadId")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"mailboxIds")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"keywords")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"size")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"receivedAt")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"messageId")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"inReplyTo")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"references")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"sender")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"from")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"to")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"cc")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"bcc")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"replyTo")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"subject")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"sentAt")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"hasAttachment")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"preview")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"bodyValues")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"textBody")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"htmlBody")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"attachments")).value()))}));
    private static final Properties allowedProperties = Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"id")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"size")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"bodyStructure")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"textBody")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"htmlBody")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"attachments")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"headers")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"bodyValues")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"messageId")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"inReplyTo")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"references")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"to")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"cc")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"bcc")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"from")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"sender")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"replyTo")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"subject")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"sentAt")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"mailboxIds")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"blobId")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"threadId")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"receivedAt")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"preview")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"hasAttachment")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"keywords")).value()))}));
    private static final Properties idProperty = Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"id")).value()))}));

    private Logger logger() {
        return logger;
    }

    public Try<Keywords> mergeKeywords(Seq<MessageResult> messages) {
        return ((Try)implicits$.MODULE$.toTraverseOps(((IterableOps)messages.map((Function1 & Serializable)x$1 -> x$1.getFlags())).map((Function1 & Serializable)flags -> KeywordsFactory$.MODULE$.LENIENT_KEYWORDS_FACTORY().fromFlags((Flags)flags)), UnorderedFoldable$.MODULE$.catsTraverseForSeq()).sequence((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Applicative)implicits$.MODULE$.catsStdInstancesForTry())).map((Function1 & Serializable)list -> (Keywords)list.reduce((Function2 & Serializable)(x$2, x$3) -> x$2.$plus$plus((Keywords)x$3)));
    }

    public Charset defaultCharset() {
        return defaultCharset;
    }

    public Properties defaultProperties() {
        return defaultProperties;
    }

    public Properties allowedProperties() {
        return allowedProperties;
    }

    public Properties idProperty() {
        return idProperty;
    }

    public Either<IllegalArgumentException, Properties> validateProperties(Option<Properties> properties) {
        Option<Properties> option = properties;
        if (None$.MODULE$.equals(option)) {
            return new Right((Object)this.defaultProperties());
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Properties properties2 = (Properties)some.value();
            Set invalidProperties = (Set)((SetOps)properties2.value().flatMap((Function1 & Serializable)property -> Email$.$anonfun$validateProperties$1((String)((Refined)property).value()))).$minus$minus(this.allowedProperties().value());
            if (invalidProperties.nonEmpty()) {
                return new Left((Object)new IllegalArgumentException("The following properties [" + ((IterableOnceOps)invalidProperties.map((Function1 & Serializable)p -> (String)((Refined)p).value())).mkString(", ") + "] do not exist."));
            }
            return new Right((Object)properties2.$plus$plus(this.idProperty()));
        }
        throw new MatchError(option);
    }

    public Either<IllegalArgumentException, Properties> validateBodyProperties(Option<Properties> bodyProperties) {
        Option<Properties> option = bodyProperties;
        if (None$.MODULE$.equals(option)) {
            return new Right((Object)EmailBodyPart$.MODULE$.defaultProperties());
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Properties properties = (Properties)some.value();
            Set invalidProperties = (Set)((SetOps)properties.value().flatMap((Function1 & Serializable)property -> Email$.$anonfun$validateBodyProperties$1((String)((Refined)property).value()))).$minus$minus(EmailBodyPart$.MODULE$.allowedProperties().value());
            if (invalidProperties.nonEmpty()) {
                return new Left((Object)new IllegalArgumentException("The following bodyProperties [" + ((IterableOnceOps)invalidProperties.map((Function1 & Serializable)p -> (String)((Refined)p).value())).mkString(", ") + "] do not exist."));
            }
            return new Right((Object)properties);
        }
        throw new MatchError(option);
    }

    public Try<UnparsedEmailId> asUnparsed(MessageId messageId) {
        Either either = package$.MODULE$.refineV().apply((Object)messageId.serialize(), Id$.MODULE$.validateId());
        if (either instanceof Left) {
            Left left = (Left)either;
            String e = (String)left.value();
            return new Failure((Throwable)new IllegalArgumentException(e));
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            String value = (String)((Refined)right.value()).value();
            return new Success((Object)new UnparsedEmailId(value));
        }
        throw new MatchError((Object)either);
    }

    public Try<Message> parseAsMime4JMessage(MessageResult messageResult) {
        return this.parseStreamAsMime4JMessage((Function0<InputStream>)(Function0 & Serializable)() -> messageResult.getFullContent().getInputStream());
    }

    public Try<Message> parseStreamAsMime4JMessage(Function0<InputStream> inputStream) {
        DefaultMessageBuilder defaultMessageBuilder = new DefaultMessageBuilder();
        defaultMessageBuilder.setMimeEntityConfig(MimeConfig.PERMISSIVE);
        defaultMessageBuilder.setDecodeMonitor(DecodeMonitor.SILENT);
        defaultMessageBuilder.setBodyDescriptorBuilder((BodyDescriptorBuilder)new JamesBodyDescriptorBuilder(null, (FieldParser<? extends ParsedField>)LenientFieldParser.getParser(), DecodeMonitor.SILENT));
        defaultMessageBuilder.setBodyFactory((BodyFactory)new AvoidBinaryBodyBufferingBodyFactory(this.defaultCharset()));
        Try resultMessage = Try$.MODULE$.apply((Function0 & Serializable)() -> defaultMessageBuilder.parseMessage((InputStream)inputStream.apply()));
        return (Try)resultMessage.fold((Function1 & Serializable)e -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> ((InputStream)inputStream.apply()).close()).flatMap((Function1 & Serializable)closeFailure -> {
            MODULE$.logger().error("Could not close " + inputStream.apply(), closeFailure);
            return new Failure(e);
        }), (Function1 & Serializable)msg -> (Success)Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> ((InputStream)inputStream.apply()).close()).fold((Function1 & Serializable)closeFailure -> {
            MODULE$.logger().error("Could not close " + inputStream.apply(), closeFailure);
            return new Success(msg);
        }, (Function1 & Serializable)x$6 -> new Success(msg)));
    }

    public static final /* synthetic */ Some $anonfun$validateProperties$2(String invalidProperty) {
        return new Some((Object)new Refined((Object)invalidProperty));
    }

    public static final /* synthetic */ Option $anonfun$validateProperties$1(String property) {
        return (Option)SpecificHeaderRequest$.MODULE$.from(property).fold((Function1 & Serializable)invalidProperty -> Email$.$anonfun$validateProperties$2((String)((Refined)invalidProperty).value()), (Function1 & Serializable)x$4 -> None$.MODULE$);
    }

    public static final /* synthetic */ Some $anonfun$validateBodyProperties$2(String invalidProperty) {
        return new Some((Object)new Refined((Object)invalidProperty));
    }

    public static final /* synthetic */ Option $anonfun$validateBodyProperties$1(String property) {
        return (Option)SpecificHeaderRequest$.MODULE$.from(property).fold((Function1 & Serializable)invalidProperty -> Email$.$anonfun$validateBodyProperties$2((String)((Refined)invalidProperty).value()), (Function1 & Serializable)x$5 -> None$.MODULE$);
    }

    private Email$() {
    }
}

