/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.cql;

import com.datastax.oss.driver.api.core.cql.TraceEvent;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Date;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultTraceEvent
implements TraceEvent {
    private final String activity;
    private final long timestamp;
    private final InetSocketAddress source;
    private final int sourceElapsedMicros;
    private final String threadName;

    public DefaultTraceEvent(String activity, long timestamp, InetSocketAddress source, int sourceElapsedMicros, String threadName) {
        this.activity = activity;
        this.timestamp = (timestamp - 122192928000000000L) / 10000L;
        this.source = source;
        this.sourceElapsedMicros = sourceElapsedMicros;
        this.threadName = threadName;
    }

    @Override
    public String getActivity() {
        return this.activity;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    @Deprecated
    public InetAddress getSource() {
        return this.source.getAddress();
    }

    @Override
    public InetSocketAddress getSourceAddress() {
        return this.source;
    }

    @Override
    public int getSourceElapsedMicros() {
        return this.sourceElapsedMicros;
    }

    @Override
    public String getThreadName() {
        return this.threadName;
    }

    public String toString() {
        return String.format("%s on %s[%s] at %s", this.activity, this.source, this.threadName, new Date(this.timestamp));
    }
}

