/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.api.message;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.model.MessageRange;

public final class UidRange
implements Iterable<MessageUid> {
    private final MessageRange range;

    public static String toString(UidRange[] ranges) {
        return Optional.ofNullable(ranges).map(ImmutableList::copyOf).toString();
    }

    public static List<UidRange> mergeRanges(List<UidRange> ranges) {
        if (ranges.isEmpty()) {
            return ranges;
        }
        RangeSet<MessageUid> rangeSet = UidRange.createSortedRangeSet(ranges);
        LinkedList<Range<MessageUid>> mergedRanges = UidRange.mergeContiguousRanges(rangeSet);
        return UidRange.toUidRanges(mergedRanges);
    }

    private static RangeSet<MessageUid> createSortedRangeSet(List<UidRange> ranges) {
        TreeRangeSet rangeSet = TreeRangeSet.create();
        for (UidRange range : ranges) {
            rangeSet.add(Range.closed((Comparable)range.getLowVal(), (Comparable)range.getHighVal()));
        }
        return rangeSet;
    }

    private static LinkedList<Range<MessageUid>> mergeContiguousRanges(RangeSet<MessageUid> rangeSet) {
        LinkedList<Range<MessageUid>> mergedRanges = new LinkedList<Range<MessageUid>>();
        for (Range range : rangeSet.asRanges()) {
            Range<MessageUid> previous;
            if (UidRange.rangesShouldBeMerged((Range<MessageUid>)range, previous = mergedRanges.peekLast())) {
                UidRange.replaceLastRange(mergedRanges, UidRange.mergeRanges((Range<MessageUid>)range, previous));
                continue;
            }
            mergedRanges.add((Range<MessageUid>)range);
        }
        return mergedRanges;
    }

    private static boolean rangesShouldBeMerged(Range<MessageUid> range, Range<MessageUid> previous) {
        return previous != null && ((MessageUid)previous.upperEndpoint()).distance((MessageUid)range.lowerEndpoint()) <= 1L;
    }

    private static void replaceLastRange(LinkedList<Range<MessageUid>> mergedRanges, Range<MessageUid> newRange) {
        mergedRanges.removeLast();
        mergedRanges.add(newRange);
    }

    private static Range<MessageUid> mergeRanges(Range<MessageUid> range, Range<MessageUid> previous) {
        return Range.closed((Comparable)((MessageUid)previous.lowerEndpoint()), (Comparable)((MessageUid)range.upperEndpoint()));
    }

    private static LinkedList<UidRange> toUidRanges(List<Range<MessageUid>> mergedRanges) {
        return mergedRanges.stream().map(range -> new UidRange((MessageUid)range.lowerEndpoint(), (MessageUid)range.upperEndpoint())).collect(Collectors.toCollection(LinkedList::new));
    }

    public UidRange(MessageUid singleVal) {
        this.range = singleVal.toRange();
    }

    public UidRange(MessageUid minValue, MessageUid messageUid) {
        if (minValue.compareTo(messageUid) > 0) {
            throw new IllegalArgumentException("LowVal must be <= HighVal");
        }
        this.range = MessageRange.range((MessageUid)minValue, (MessageUid)messageUid);
    }

    public MessageUid getLowVal() {
        return this.range.getUidFrom();
    }

    public MessageUid getHighVal() {
        return this.range.getUidTo();
    }

    public boolean includes(MessageUid value) {
        return this.range.includes(value);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.range});
    }

    public boolean equals(Object obj) {
        if (obj instanceof UidRange) {
            UidRange other = (UidRange)obj;
            return Objects.equal((Object)this.range, (Object)other.range);
        }
        return false;
    }

    public String toString() {
        return "IdRange : " + this.range.toString();
    }

    public String getFormattedString() {
        if (this.range.getUidFrom().equals((Object)this.range.getUidTo())) {
            return String.valueOf(this.range.getUidFrom().asLong());
        }
        return this.range.getUidFrom().asLong() + ":" + this.range.getUidTo().asLong();
    }

    @Override
    public Iterator<MessageUid> iterator() {
        return this.range.iterator();
    }

    public MessageRange toMessageRange() {
        return this.range;
    }
}

