/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.github.fge.lambdas.consumers.ThrowingConsumer;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import jakarta.mail.MessagingException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.james.core.MailAddress;
import org.apache.james.user.api.UsersRepository;
import org.apache.mailet.Mail;
import org.apache.mailet.StorageDirective;
import org.apache.mailet.base.GenericMailet;

public class WithStorageDirective
extends GenericMailet {
    static final String TARGET_FOLDER_NAME = "targetFolderName";
    static final String TARGET_FOLDER_NAMES = "targetFolderNames";
    static final String SEEN = "seen";
    static final String IMPORTANT = "important";
    static final String KEYWORDS = "keywords";
    private static final Splitter KEYWORD_SPLITTER = Splitter.on((char)',').omitEmptyStrings().trimResults();
    private final UsersRepository usersRepository;
    private StorageDirective storageDirective;

    @Inject
    public WithStorageDirective(UsersRepository usersRepository) {
        this.usersRepository = usersRepository;
    }

    public void init() throws MessagingException {
        Preconditions.checkState((boolean)this.validBooleanParameter(this.getInitParameterAsOptional(SEEN)), (String)"'%s' needs to be a boolean", (Object)SEEN);
        Preconditions.checkState((boolean)this.validBooleanParameter(this.getInitParameterAsOptional(IMPORTANT)), (String)"'%s' needs to be a boolean", (Object)IMPORTANT);
        this.storageDirective = StorageDirective.builder().targetFolders(this.targetFolders()).seen(this.getInitParameterAsOptional(SEEN).map(Boolean::parseBoolean)).important(this.getInitParameterAsOptional(IMPORTANT).map(Boolean::parseBoolean)).keywords(this.getInitParameterAsOptional(KEYWORDS).map(this::parseKeywords)).build();
    }

    private Optional<List<String>> targetFolders() {
        return this.getInitParameterAsOptional(TARGET_FOLDER_NAMES).map(names -> Splitter.on((char)',').omitEmptyStrings().trimResults().splitToList((CharSequence)names)).or(() -> this.getInitParameterAsOptional(TARGET_FOLDER_NAME).map(ImmutableList::of));
    }

    private Collection<String> parseKeywords(String s) {
        return KEYWORD_SPLITTER.splitToList((CharSequence)s);
    }

    private boolean validBooleanParameter(Optional<String> parameter) {
        return parameter.map(v -> v.equals("true") || v.equals("false")).orElse(true);
    }

    public void service(Mail mail) throws MessagingException {
        mail.getRecipients().forEach(this.addStorageDirective(mail));
    }

    public ThrowingConsumer<MailAddress> addStorageDirective(Mail mail) {
        return recipient -> this.storageDirective.encodeAsAttributes(this.usersRepository.getUsername(recipient)).forEach(arg_0 -> ((Mail)mail).setAttribute(arg_0));
    }
}

