/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model.search;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.james.mailbox.model.search.MailboxNameExpression;

public class PrefixedWildcard
implements MailboxNameExpression {
    private final String prefix;

    public PrefixedWildcard(String prefix) {
        Preconditions.checkNotNull(prefix);
        this.prefix = prefix;
    }

    @Override
    public boolean isExpressionMatch(String name) {
        return name.startsWith(this.prefix);
    }

    @Override
    public String getCombinedName() {
        return this.prefix + "*";
    }

    @Override
    public boolean isWild() {
        return true;
    }

    @Override
    public MailboxNameExpression includeChildren() {
        return this;
    }

    public final boolean equals(Object o) {
        if (o instanceof PrefixedWildcard) {
            PrefixedWildcard that = (PrefixedWildcard)o;
            return Objects.equals(this.prefix, that.prefix);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.prefix);
    }
}

