/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.spring.generator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.xbean.spring.generator.AttributeMapping;
import org.apache.xbean.spring.generator.ElementMapping;
import org.apache.xbean.spring.generator.GeneratorPlugin;
import org.apache.xbean.spring.generator.LogFacade;
import org.apache.xbean.spring.generator.NamespaceMapping;
import org.apache.xbean.spring.generator.Type;

public class WikiDocumentationGenerator
implements GeneratorPlugin {
    private final File destFile;
    private LogFacade log;

    public WikiDocumentationGenerator(File destFile) {
        this.destFile = destFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(NamespaceMapping namespaceMapping) throws IOException {
        String namespace = namespaceMapping.getNamespace();
        File file = new File(this.destFile.getParentFile(), this.destFile.getName() + ".wiki");
        this.log.log("Generating WIKI documentation file: " + file + " for namespace: " + namespace);
        try (PrintWriter out = new PrintWriter(new FileWriter(file));){
            this.generateDocumentation(out, namespaceMapping);
        }
    }

    private void generateDocumentation(PrintWriter out, NamespaceMapping namespaceMapping) {
        HashMap refercencedTypes = new HashMap();
        for (ElementMapping elementMapping : namespaceMapping.getElements()) {
            for (AttributeMapping attribute : elementMapping.getAttributes()) {
                Type type = this.getNestedType(attribute.getType());
                if (namespaceMapping.isSimpleType(type) || refercencedTypes.containsKey(type.getName())) continue;
                refercencedTypes.put(type.getName(), new ArrayList());
            }
        }
        for (Map.Entry entry : refercencedTypes.entrySet()) {
            String type = (String)entry.getKey();
            ArrayList implementations = (ArrayList)entry.getValue();
            block3: for (ElementMapping element : namespaceMapping.getElements()) {
                boolean matched = false;
                if (type.equals(element.getClassName())) {
                    implementations.add(element);
                    matched = true;
                }
                if (!matched) {
                    for (String t : element.getSuperClasses()) {
                        if (!type.equals(t)) continue;
                        implementations.add(element);
                        matched = true;
                        break;
                    }
                }
                if (matched) continue;
                for (String t : element.getInterfaces()) {
                    if (!type.equals(t)) continue;
                    implementations.add(element);
                    matched = true;
                    continue block3;
                }
            }
        }
        Iterator<Object> iter = refercencedTypes.values().iterator();
        while (iter.hasNext()) {
            ArrayList arrayList = (ArrayList)iter.next();
            if (!arrayList.isEmpty()) continue;
            iter.remove();
        }
        this.generateElementsByType(out, namespaceMapping, refercencedTypes);
        this.generateElementsDetail(out, namespaceMapping, refercencedTypes);
        this.generateElementsIndex(out, namespaceMapping, refercencedTypes);
    }

    private Type getNestedType(Type type) {
        if (type.isCollection()) {
            return this.getNestedType(type.getNestedType());
        }
        return type;
    }

    private void generateElementsByType(PrintWriter out, NamespaceMapping namespaceMapping, HashMap refercencedTypes) {
        out.println("h3. Elements By Type");
        for (Map.Entry entry : refercencedTypes.entrySet()) {
            String className = (String)entry.getKey();
            Collection elements = (Collection)entry.getValue();
            out.println("{anchor:" + className + "-types}");
            out.println("h4. The _[" + className + "|#" + className + "-types]_ Type Implementations");
            for (ElementMapping element : elements) {
                out.println("    | _[<" + element.getElementName() + ">|#" + element.getElementName() + "-element]_ | {html}" + element.getDescription() + "{html} |");
            }
            out.println();
        }
        out.println();
    }

    private void generateElementsIndex(PrintWriter out, NamespaceMapping namespaceMapping, HashMap refercencedTypes) {
        out.println("h3. Element Index");
        for (ElementMapping element : namespaceMapping.getElements()) {
            out.println("    | _[<" + element.getElementName() + ">|#" + element.getElementName() + "-element]_ | {html}" + element.getDescription() + "{html} |");
        }
        out.println();
    }

    private void generateElementsDetail(PrintWriter out, NamespaceMapping namespaceMapping, HashMap refercencedTypes) {
        for (ElementMapping element : namespaceMapping.getElements()) {
            this.generateElementDetail(out, namespaceMapping, element, refercencedTypes);
        }
    }

    private void generateElementDetail(PrintWriter out, NamespaceMapping namespaceMapping, ElementMapping element, HashMap refercencedTypes) {
        out.println("{anchor:" + element.getElementName() + "-element}");
        out.println("h3. The _[<" + element.getElementName() + ">|#" + element.getElementName() + "-element]_ Element");
        out.println("    {html}" + element.getDescription() + "{html}");
        if (element.getAttributes().size() > 0) {
            out.println("h4. Properties");
            out.println("    || Property Name || Type || Description ||");
            for (AttributeMapping attribute : element.getAttributes()) {
                Type type = attribute.getPropertyEditor() != null ? Type.newSimpleType(String.class.getName()) : attribute.getType();
                out.println("    | " + attribute.getAttributeName() + " | " + this.getTypeLink(type, refercencedTypes) + " | {html}" + attribute.getDescription() + "{html} |");
            }
        }
        out.println();
    }

    private String getTypeLink(Type type, HashMap refercencedTypes) {
        if (type.isCollection()) {
            return "(" + this.getTypeLink(type.getNestedType(), refercencedTypes) + ")\\*";
        }
        if (refercencedTypes.containsKey(type.getName())) {
            return "_[" + type.getName() + "|#" + type.getName() + "-types]_";
        }
        return "_" + type.getName() + "_";
    }

    @Override
    public LogFacade getLog() {
        return this.log;
    }

    @Override
    public void setLog(LogFacade log) {
        this.log = log;
    }
}

