/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.jsonfilter;

import com.unboundid.ldap.sdk.unboundidds.jsonfilter.JSONObjectFilter;
import com.unboundid.util.Mutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.json.JSONArray;
import com.unboundid.util.json.JSONBoolean;
import com.unboundid.util.json.JSONException;
import com.unboundid.util.json.JSONNumber;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class EqualsJSONObjectFilter
extends JSONObjectFilter {
    @NotNull
    public static final String FILTER_TYPE = "equals";
    @NotNull
    public static final String FIELD_FIELD_PATH = "field";
    @NotNull
    public static final String FIELD_VALUE = "value";
    @NotNull
    public static final String FIELD_CASE_SENSITIVE = "caseSensitive";
    @NotNull
    private static final Set<String> REQUIRED_FIELD_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("field", "value")));
    @NotNull
    private static final Set<String> OPTIONAL_FIELD_NAMES = Collections.unmodifiableSet(new HashSet<String>(Collections.singletonList("caseSensitive")));
    private static final long serialVersionUID = 4622567662624840125L;
    private volatile boolean caseSensitive;
    @NotNull
    private volatile JSONValue value;
    @NotNull
    private volatile List<String> field;

    EqualsJSONObjectFilter() {
        this.field = null;
        this.value = null;
        this.caseSensitive = false;
    }

    private EqualsJSONObjectFilter(@NotNull List<String> field, @NotNull JSONValue value, boolean caseSensitive) {
        this.field = field;
        this.value = value;
        this.caseSensitive = caseSensitive;
    }

    public EqualsJSONObjectFilter(@NotNull String field, @NotNull String value) {
        this(Collections.singletonList(field), (JSONValue)new JSONString(value));
    }

    public EqualsJSONObjectFilter(@NotNull String field, boolean value) {
        this(Collections.singletonList(field), (JSONValue)(value ? JSONBoolean.TRUE : JSONBoolean.FALSE));
    }

    public EqualsJSONObjectFilter(@NotNull String field, long value) {
        this(Collections.singletonList(field), (JSONValue)new JSONNumber(value));
    }

    public EqualsJSONObjectFilter(@NotNull String field, double value) {
        this(Collections.singletonList(field), (JSONValue)new JSONNumber(value));
    }

    public EqualsJSONObjectFilter(@NotNull String field, @NotNull JSONValue value) {
        this(Collections.singletonList(field), value);
    }

    public EqualsJSONObjectFilter(@NotNull List<String> field, @NotNull JSONValue value) {
        Validator.ensureNotNull(field);
        Validator.ensureFalse(field.isEmpty());
        Validator.ensureNotNull(value);
        this.field = Collections.unmodifiableList(new ArrayList<String>(field));
        this.value = value;
        this.caseSensitive = false;
    }

    @NotNull
    public List<String> getField() {
        return this.field;
    }

    public void setField(String ... field) {
        this.setField(StaticUtils.toList(field));
    }

    public void setField(@NotNull List<String> field) {
        Validator.ensureNotNull(field);
        Validator.ensureFalse(field.isEmpty());
        this.field = Collections.unmodifiableList(new ArrayList<String>(field));
    }

    @NotNull
    public JSONValue getValue() {
        return this.value;
    }

    public void setValue(@NotNull String value) {
        Validator.ensureNotNull(value);
        this.value = new JSONString(value);
    }

    public void setValue(boolean value) {
        this.value = value ? JSONBoolean.TRUE : JSONBoolean.FALSE;
    }

    public void setValue(long value) {
        this.value = new JSONNumber(value);
    }

    public void setValue(double value) {
        this.value = new JSONNumber(value);
    }

    public void setValue(@NotNull JSONValue value) {
        Validator.ensureNotNull(value);
        this.value = value;
    }

    public boolean caseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    @Override
    @NotNull
    public String getFilterType() {
        return FILTER_TYPE;
    }

    @Override
    @NotNull
    protected Set<String> getRequiredFieldNames() {
        return REQUIRED_FIELD_NAMES;
    }

    @Override
    @NotNull
    protected Set<String> getOptionalFieldNames() {
        return OPTIONAL_FIELD_NAMES;
    }

    @Override
    public boolean matchesJSONObject(@NotNull JSONObject o) {
        List<JSONValue> candidates = EqualsJSONObjectFilter.getValues(o, this.field);
        if (candidates.isEmpty()) {
            return false;
        }
        for (JSONValue v : candidates) {
            JSONArray a;
            if (this.value.equals(v, false, !this.caseSensitive, false)) {
                return true;
            }
            if (!(v instanceof JSONArray) || !(a = (JSONArray)v).contains(this.value, false, !this.caseSensitive, false, false)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public JSONObject toJSONObject() {
        LinkedHashMap<String, JSONValue> fields = new LinkedHashMap<String, JSONValue>(StaticUtils.computeMapCapacity(4));
        fields.put("filterType", new JSONString(FILTER_TYPE));
        if (this.field.size() == 1) {
            fields.put(FIELD_FIELD_PATH, new JSONString(this.field.get(0)));
        } else {
            ArrayList<JSONString> fieldNameValues = new ArrayList<JSONString>(this.field.size());
            for (String s : this.field) {
                fieldNameValues.add(new JSONString(s));
            }
            fields.put(FIELD_FIELD_PATH, new JSONArray(fieldNameValues));
        }
        fields.put(FIELD_VALUE, this.value);
        if (this.caseSensitive) {
            fields.put(FIELD_CASE_SENSITIVE, JSONBoolean.TRUE);
        }
        return new JSONObject(fields);
    }

    @Override
    @NotNull
    protected EqualsJSONObjectFilter decodeFilter(@NotNull JSONObject filterObject) throws JSONException {
        List<String> fieldPath = this.getStrings(filterObject, FIELD_FIELD_PATH, false, null);
        boolean isCaseSensitive = this.getBoolean(filterObject, FIELD_CASE_SENSITIVE, false);
        return new EqualsJSONObjectFilter(fieldPath, filterObject.getField(FIELD_VALUE), isCaseSensitive);
    }
}

