/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.onami.lifecycle;

import com.google.inject.TypeLiteral;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;

abstract class AbstractMethodTypeListener
implements TypeListener {
    private static final String JAVA_PACKAGE = "java";
    protected final List<? extends Class<? extends Annotation>> annotationTypes;

    public AbstractMethodTypeListener(List<? extends Class<? extends Annotation>> annotationTypes) {
        this.annotationTypes = annotationTypes;
    }

    public final <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
        this.hear(type, type.getRawType(), encounter);
    }

    private <I> void hear(TypeLiteral<I> parentType, Class<? super I> klass, TypeEncounter<I> encounter) {
        Package pkg;
        if (klass == null || (pkg = klass.getPackage()) != null && pkg.getName().startsWith(JAVA_PACKAGE)) {
            return;
        }
        for (Class<? extends Annotation> clazz : this.annotationTypes) {
            for (Method method : klass.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(clazz)) continue;
                if (method.getParameterTypes().length != 0) {
                    encounter.addError("Annotated methods with @%s must not accept any argument, found %s", new Object[]{clazz.getName(), method});
                }
                this.hear(method, parentType, encounter, clazz);
            }
        }
        this.hear(parentType, klass.getSuperclass(), encounter);
    }

    protected abstract <I> void hear(Method var1, TypeLiteral<I> var2, TypeEncounter<I> var3, Class<? extends Annotation> var4);
}

