/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules;

import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.probe.QuotaProbe;
import org.apache.james.mailbox.quota.MaxQuotaManager;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.utils.GuiceProbe;

public class QuotaProbesImpl
implements QuotaProbe,
GuiceProbe {
    private final MaxQuotaManager maxQuotaManager;
    private final QuotaRootResolver quotaRootResolver;
    private final QuotaManager quotaManager;

    @Inject
    public QuotaProbesImpl(MaxQuotaManager maxQuotaManager, QuotaRootResolver quotaRootResolver, QuotaManager quotaManager) {
        this.maxQuotaManager = maxQuotaManager;
        this.quotaRootResolver = quotaRootResolver;
        this.quotaManager = quotaManager;
    }

    public QuotaRoot getQuotaRoot(MailboxPath mailboxPath) throws MailboxException {
        return this.quotaRootResolver.getQuotaRoot(mailboxPath);
    }

    public Quota<QuotaCountLimit, QuotaCountUsage> getMessageCountQuota(QuotaRoot quotaRoot) throws MailboxException {
        return this.quotaManager.getMessageQuota(quotaRoot);
    }

    public Quota<QuotaSizeLimit, QuotaSizeUsage> getStorageQuota(QuotaRoot quotaRoot) throws MailboxException {
        return this.quotaManager.getStorageQuota(quotaRoot);
    }

    public Optional<QuotaCountLimit> getMaxMessageCount(QuotaRoot quotaRoot) throws MailboxException {
        return this.maxQuotaManager.getMaxMessage(quotaRoot);
    }

    public Optional<QuotaSizeLimit> getMaxStorage(QuotaRoot quotaRoot) throws MailboxException {
        return this.maxQuotaManager.getMaxStorage(quotaRoot);
    }

    public Optional<QuotaCountLimit> getGlobalMaxMessageCount() throws MailboxException {
        return this.maxQuotaManager.getGlobalMaxMessage();
    }

    public Optional<QuotaSizeLimit> getGlobalMaxStorage() throws MailboxException {
        return this.maxQuotaManager.getGlobalMaxStorage();
    }

    public void setMaxMessageCount(QuotaRoot quotaRoot, QuotaCountLimit maxMessageCount) throws MailboxException {
        this.maxQuotaManager.setMaxMessage(quotaRoot, maxMessageCount);
    }

    public void setMaxStorage(QuotaRoot quotaRoot, QuotaSizeLimit maxSize) throws MailboxException {
        this.maxQuotaManager.setMaxStorage(quotaRoot, maxSize);
    }

    public void setGlobalMaxMessageCount(QuotaCountLimit maxGlobalMessageCount) throws MailboxException {
        this.maxQuotaManager.setGlobalMaxMessage(maxGlobalMessageCount);
    }

    public void setGlobalMaxStorage(QuotaSizeLimit maxGlobalSize) throws MailboxException {
        this.maxQuotaManager.setGlobalMaxStorage(maxGlobalSize);
    }
}

