/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DeleteRequest;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class SoftDeleteRequestControl
extends Control {
    @NotNull
    public static final String SOFT_DELETE_REQUEST_OID = "1.3.6.1.4.1.30221.2.5.20";
    private static final byte TYPE_RETURN_SOFT_DELETE_RESPONSE = -128;
    private static final long serialVersionUID = 4068029406430690545L;
    private final boolean returnSoftDeleteResponse;

    public SoftDeleteRequestControl() {
        this(true, true);
    }

    public SoftDeleteRequestControl(boolean isCritical, boolean returnSoftDeleteResponse) {
        super(SOFT_DELETE_REQUEST_OID, isCritical, SoftDeleteRequestControl.encodeValue(returnSoftDeleteResponse));
        this.returnSoftDeleteResponse = returnSoftDeleteResponse;
    }

    public SoftDeleteRequestControl(@NotNull Control control) throws LDAPException {
        super(control);
        boolean returnResponse = true;
        if (control.hasValue()) {
            try {
                ASN1Sequence valueSequence = ASN1Sequence.decodeAsSequence(control.getValue().getValue());
                block6: for (ASN1Element e : valueSequence.elements()) {
                    switch (e.getType()) {
                        case -128: {
                            returnResponse = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                            continue block6;
                        }
                        default: {
                            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SOFT_DELETE_REQUEST_UNSUPPORTED_VALUE_ELEMENT_TYPE.get(StaticUtils.toHex(e.getType())));
                        }
                    }
                }
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                throw le;
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SOFT_DELETE_REQUEST_CANNOT_DECODE_VALUE.get(StaticUtils.getExceptionMessage(e)), e);
            }
        }
        this.returnSoftDeleteResponse = returnResponse;
    }

    @Nullable
    private static ASN1OctetString encodeValue(boolean returnSoftDeleteResponse) {
        if (returnSoftDeleteResponse) {
            return null;
        }
        ArrayList<ASN1Boolean> elements = new ArrayList<ASN1Boolean>(1);
        elements.add(new ASN1Boolean(-128, false));
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    public boolean returnSoftDeleteResponse() {
        return this.returnSoftDeleteResponse;
    }

    @NotNull
    public static DeleteRequest createSoftDeleteRequest(@NotNull String targetDN, boolean isCritical, boolean returnSoftDeleteResponse) {
        Control[] controls = new Control[]{new SoftDeleteRequestControl(isCritical, returnSoftDeleteResponse)};
        return new DeleteRequest(targetDN, controls);
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_SOFT_DELETE_REQUEST.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("SoftDeleteRequestControl(isCritical=");
        buffer.append(this.isCritical());
        buffer.append(", returnSoftDeleteResponse=");
        buffer.append(this.returnSoftDeleteResponse);
        buffer.append(')');
    }
}

