/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.http;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.jmap.exceptions.UnauthorizedException;
import org.apache.james.jmap.http.AuthenticationChallenge;
import org.apache.james.jmap.http.AuthenticationScheme;
import org.apache.james.jmap.http.AuthenticationStrategy;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import reactor.core.publisher.Mono;
import reactor.netty.http.server.HttpServerRequest;

public class XUserAuthenticationStrategy
implements AuthenticationStrategy {
    private static final String X_USER_HEADER_NAME = "X-User";
    private static final AuthenticationChallenge X_USER_CHALLENGE = AuthenticationChallenge.of(AuthenticationScheme.of("XUserHeader"), (Map<String, String>)ImmutableMap.of());
    private final UsersRepository usersRepository;
    private final MailboxManager mailboxManager;

    @Inject
    public XUserAuthenticationStrategy(UsersRepository usersRepository, MailboxManager mailboxManager) {
        this.usersRepository = usersRepository;
        this.mailboxManager = mailboxManager;
    }

    @Override
    public Mono<MailboxSession> createMailboxSession(HttpServerRequest httpRequest) {
        return Optional.ofNullable(httpRequest.requestHeaders().get(X_USER_HEADER_NAME)).map(String::trim).filter(s -> !s.isEmpty()).map(Username::of).map(this::createMailboxSession).orElse(Mono.empty());
    }

    private Mono<MailboxSession> createMailboxSession(Username username) {
        return Mono.fromCallable(() -> {
            try {
                this.usersRepository.assertValid(username);
            }
            catch (UsersRepositoryException e) {
                throw new UnauthorizedException("Invalid username", e);
            }
            return this.mailboxManager.createSystemSession(username);
        });
    }

    @Override
    public AuthenticationChallenge correspondingChallenge() {
        return X_USER_CHALLENGE;
    }
}

