/*
 * Decompiled with CFR 0.152.
 */
package feign.template;

import feign.Util;
import feign.template.Expression;
import feign.template.UriUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Expressions {
    private static Map<Pattern, Class<? extends Expression>> expressions = new LinkedHashMap<Pattern, Class<? extends Expression>>();

    public static Expression create(String value) {
        String expression = Expressions.stripBraces(value);
        if (expression == null || expression.isEmpty()) {
            throw new IllegalArgumentException("an expression is required.");
        }
        Optional<Map.Entry> matchedExpressionEntry = expressions.entrySet().stream().filter(entry -> ((Pattern)entry.getKey()).matcher(expression).matches()).findFirst();
        if (!matchedExpressionEntry.isPresent()) {
            return null;
        }
        Map.Entry matchedExpression = matchedExpressionEntry.get();
        Pattern expressionPattern = (Pattern)matchedExpression.getKey();
        String variableName = null;
        String variablePattern = null;
        Matcher matcher = expressionPattern.matcher(expression);
        if (matcher.matches()) {
            variableName = matcher.group(2).trim();
            if (variableName.contains(":")) {
                String[] parts = variableName.split(":");
                variableName = parts[0];
                variablePattern = parts[1];
            }
            if (variableName.contains("{")) {
                return null;
            }
        }
        return new SimpleExpression(variableName, variablePattern);
    }

    private static String stripBraces(String expression) {
        if (expression == null) {
            return null;
        }
        if (expression.startsWith("{") && expression.endsWith("}")) {
            return expression.substring(1, expression.length() - 1);
        }
        return expression;
    }

    static {
        expressions.put(Pattern.compile("^([+#./;?&]?)(.*)$"), SimpleExpression.class);
    }

    static class SimpleExpression
    extends Expression {
        SimpleExpression(String expression, String pattern) {
            super(expression, pattern);
        }

        String encode(Object value) {
            return UriUtils.encode(value.toString(), Util.UTF_8);
        }

        @Override
        String expand(Object variable, boolean encode) {
            StringBuilder expanded = new StringBuilder();
            if (Iterable.class.isAssignableFrom(variable.getClass())) {
                expanded.append(this.expandIterable((Iterable)variable));
            } else {
                expanded.append(encode ? this.encode(variable) : variable);
            }
            String result = expanded.toString();
            if (!this.matches(result)) {
                throw new IllegalArgumentException("Value " + expanded + " does not match the expression pattern: " + this.getPattern());
            }
            return result;
        }

        private String expandIterable(Iterable<?> values) {
            StringBuilder result = new StringBuilder();
            for (Object value : values) {
                if (value == null) continue;
                String expanded = this.encode(value);
                if (expanded.isEmpty()) {
                    result.append(",");
                    continue;
                }
                if (result.length() != 0 && !result.toString().equalsIgnoreCase(",")) {
                    result.append(",");
                }
                result.append(expanded);
            }
            return result.toString();
        }
    }
}

